<?php

namespace EnumType;

/**
 * This class stands for RetoureGrund EnumType
 * @subpackage Enumerations
 */
class RetoureGrund
{
    /**
     * Constant for value 'Bestellfehler'
     * @return string 'Bestellfehler'
     */
    const VALUE_BESTELLFEHLER = 'Bestellfehler';
    /**
     * Constant for value 'BerechnetNichtGeliefert'
     * @return string 'BerechnetNichtGeliefert'
     */
    const VALUE_BERECHNET_NICHT_GELIEFERT = 'BerechnetNichtGeliefert';
    /**
     * Constant for value 'Beschaedigt'
     * @return string 'Beschaedigt'
     */
    const VALUE_BESCHAEDIGT = 'Beschaedigt';
    /**
     * Constant for value 'VerfallZuKurz'
     * @return string 'VerfallZuKurz'
     */
    const VALUE_VERFALL_ZU_KURZ = 'VerfallZuKurz';
    /**
     * Constant for value 'ZuvielGeliefert'
     * @return string 'ZuvielGeliefert'
     */
    const VALUE_ZUVIEL_GELIEFERT = 'ZuvielGeliefert';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BESTELLFEHLER
     * @uses self::VALUE_BERECHNET_NICHT_GELIEFERT
     * @uses self::VALUE_BESCHAEDIGT
     * @uses self::VALUE_VERFALL_ZU_KURZ
     * @uses self::VALUE_ZUVIEL_GELIEFERT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BESTELLFEHLER,
            self::VALUE_BERECHNET_NICHT_GELIEFERT,
            self::VALUE_BESCHAEDIGT,
            self::VALUE_VERFALL_ZU_KURZ,
            self::VALUE_ZUVIEL_GELIEFERT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
