<?php

namespace EnumType;

/**
 * This class stands for Bestellstatus EnumType
 * @subpackage Enumerations
 */
class Bestellstatus
{
    /**
     * Constant for value 'KennungUnbekannt'
     * @return string 'KennungUnbekannt'
     */
    const VALUE_KENNUNG_UNBEKANNT = 'KennungUnbekannt';
    /**
     * Constant for value 'BestellantwortNichtVerfuegbar'
     * @return string 'BestellantwortNichtVerfuegbar'
     */
    const VALUE_BESTELLANTWORT_NICHT_VERFUEGBAR = 'BestellantwortNichtVerfuegbar';
    /**
     * Constant for value 'BestellantwortVerfuegbar'
     * @return string 'BestellantwortVerfuegbar'
     */
    const VALUE_BESTELLANTWORT_VERFUEGBAR = 'BestellantwortVerfuegbar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KENNUNG_UNBEKANNT
     * @uses self::VALUE_BESTELLANTWORT_NICHT_VERFUEGBAR
     * @uses self::VALUE_BESTELLANTWORT_VERFUEGBAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KENNUNG_UNBEKANNT,
            self::VALUE_BESTELLANTWORT_NICHT_VERFUEGBAR,
            self::VALUE_BESTELLANTWORT_VERFUEGBAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
