<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VertragsdatenBestellfenster StructType
 * @subpackage Structs
 */
class VertragsdatenBestellfenster extends AbstractStructBase
{
    /**
     * The Tag
     * @var string
     */
    public $Tag;
    /**
     * The Endezeit
     * Meta informations extracted from the WSDL
     * - documentation: es duerfen nur ganze Minuten angegeben werden! Als technische Reserve zaehlt eine Bestellung noch zum alten Bestellfenster, wenn die Bestelluebertragung beim GH bis zur angegebenen Zeit + 59Sekunden startet. | Es duerfen nur ganze
     * Minuten angegeben werden! Als technische Reserve zaehlt eine Bestellung noch zum alten Bestellfenster, wenn die Bestelluebertragung beim GH bis zur angegebenen Zeit + 59Sekunden startet.
     * - pattern: \d\d:\d\d:00
     * @var string
     */
    public $Endezeit;
    /**
     * The Hauptbestellzeit
     * Meta informations extracted from the WSDL
     * - documentation: Zeitpunkt INNERHALB des Bestellfensters an dem die Hauptbestellung durchgefuehrt werden soll
     * @var \StructType\VertragsdatenHauptbestellzeit
     */
    public $Hauptbestellzeit;
    /**
     * Constructor method for VertragsdatenBestellfenster
     * @uses VertragsdatenBestellfenster::setTag()
     * @uses VertragsdatenBestellfenster::setEndezeit()
     * @uses VertragsdatenBestellfenster::setHauptbestellzeit()
     * @param string $tag
     * @param string $endezeit
     * @param \StructType\VertragsdatenHauptbestellzeit $hauptbestellzeit
     */
    public function __construct($tag = null, $endezeit = null, \StructType\VertragsdatenHauptbestellzeit $hauptbestellzeit = null)
    {
        $this
            ->setTag($tag)
            ->setEndezeit($endezeit)
            ->setHauptbestellzeit($hauptbestellzeit);
    }
    /**
     * Get Tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @uses \EnumType\VertragsdatenTag::valueIsValid()
     * @uses \EnumType\VertragsdatenTag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tag
     * @return \StructType\VertragsdatenBestellfenster
     */
    public function setTag($tag = null)
    {
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Get Endezeit value
     * @return string|null
     */
    public function getEndezeit()
    {
        return $this->Endezeit;
    }
    /**
     * Set Endezeit value
     * @param string $endezeit
     * @return \StructType\VertragsdatenBestellfenster
     */
    public function setEndezeit($endezeit = null)
    {
        $this->Endezeit = $endezeit;
        return $this;
    }
    /**
     * Get Hauptbestellzeit value
     * @return \StructType\VertragsdatenHauptbestellzeit|null
     */
    public function getHauptbestellzeit()
    {
        return $this->Hauptbestellzeit;
    }
    /**
     * Set Hauptbestellzeit value
     * @param \StructType\VertragsdatenHauptbestellzeit $hauptbestellzeit
     * @return \StructType\VertragsdatenBestellfenster
     */
    public function setHauptbestellzeit(\StructType\VertragsdatenHauptbestellzeit $hauptbestellzeit = null)
    {
        $this->Hauptbestellzeit = $hauptbestellzeit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VertragsdatenBestellfenster
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
