<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypSondertag StructType
 * @subpackage Structs
 */
class TypSondertag extends AbstractStructBase
{
    /**
     * The Datum
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Datum;
    /**
     * The Bestellfenster
     * Meta informations extracted from the WSDL
     * - documentation: Werden zu einem Sondertag keine Bestellfenster gemeldet, so bedeutet das, dass an diesem Tag kein Bestellfensterende existiert. Auf diese Weise koennen Tage ohne Belieferung behandelt werden.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\SondertagBestellfenster[]
     */
    public $Bestellfenster;
    /**
     * Constructor method for TypSondertag
     * @uses TypSondertag::setDatum()
     * @uses TypSondertag::setBestellfenster()
     * @param string $datum
     * @param \StructType\SondertagBestellfenster[] $bestellfenster
     */
    public function __construct($datum = null, array $bestellfenster = array())
    {
        $this
            ->setDatum($datum)
            ->setBestellfenster($bestellfenster);
    }
    /**
     * Get Datum value
     * @return string
     */
    public function getDatum()
    {
        return $this->Datum;
    }
    /**
     * Set Datum value
     * @param string $datum
     * @return \StructType\TypSondertag
     */
    public function setDatum($datum = null)
    {
        $this->Datum = $datum;
        return $this;
    }
    /**
     * Get Bestellfenster value
     * @return \StructType\SondertagBestellfenster[]|null
     */
    public function getBestellfenster()
    {
        return $this->Bestellfenster;
    }
    /**
     * Set Bestellfenster value
     * @throws \InvalidArgumentException
     * @param \StructType\SondertagBestellfenster[] $bestellfenster
     * @return \StructType\TypSondertag
     */
    public function setBestellfenster(array $bestellfenster = array())
    {
        $this->Bestellfenster = $bestellfenster;
        return $this;
    }
    /**
     * Add item to Bestellfenster value
     * @throws \InvalidArgumentException
     * @param \StructType\SondertagBestellfenster $item
     * @return \StructType\TypSondertag
     */
    public function addToBestellfenster(\StructType\SondertagBestellfenster $item)
    {
        $this->Bestellfenster[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypSondertag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
