<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ruecknahmeangebot StructType
 * Meta informations extracted from the WSDL
 * - documentation: nur die fachliche Anfrage
 * @subpackage Structs
 */
class Ruecknahmeangebot extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The Artikel
     * Meta informations extracted from the WSDL
     * - documentation: Spezifiziert die Artikel, welche die Apotheke dem GH zurueckgeben moechte; keine doppelten PZNs erlaubt
     * - maxOccurs: 1000
     * @var \StructType\ArtikelMenge[]
     */
    public $Artikel;
    /**
     * Constructor method for Ruecknahmeangebot
     * @uses Ruecknahmeangebot::setId()
     * @uses Ruecknahmeangebot::setArtikel()
     * @param string $id
     * @param \StructType\ArtikelMenge[] $artikel
     */
    public function __construct($id = null, array $artikel = array())
    {
        $this
            ->setId($id)
            ->setArtikel($artikel);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Ruecknahmeangebot
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Artikel value
     * @return \StructType\ArtikelMenge[]|null
     */
    public function getArtikel()
    {
        return $this->Artikel;
    }
    /**
     * Set Artikel value
     * @throws \InvalidArgumentException
     * @param \StructType\ArtikelMenge[] $artikel
     * @return \StructType\Ruecknahmeangebot
     */
    public function setArtikel(array $artikel = array())
    {
        $this->Artikel = $artikel;
        return $this;
    }
    /**
     * Add item to Artikel value
     * @throws \InvalidArgumentException
     * @param \StructType\ArtikelMenge $item
     * @return \StructType\Ruecknahmeangebot
     */
    public function addToArtikel(\StructType\ArtikelMenge $item)
    {
        $this->Artikel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ruecknahmeangebot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
