<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lieferavis StructType
 * @subpackage Structs
 */
class Lieferavis extends AbstractStructBase
{
    /**
     * The Lieferscheinnummer
     * Meta informations extracted from the WSDL
     * - documentation: fachlich und technischer PK Nummer vom Papierlieferschein
     * - use: required
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [a-zA-Z0-9#+\*[:slash:]\-_]*
     * @var string
     */
    public $Lieferscheinnummer;
    /**
     * The BarcodeReferenz
     * Meta informations extracted from the WSDL
     * - documentation: fuer Abscannen mit Praefix! (1D oder 2D)
     * - use: required
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [0-9]*[\*+#_\?][a-zA-Z0-9#+\*[:slash:]\-_\?]*
     * @var string
     */
    public $BarcodeReferenz;
    /**
     * The Auftragsart
     * Meta informations extracted from the WSDL
     * - documentation: Die Augtragsart muss immer der Anfrage-Auftragsart entsprechen.
     * - use: required
     * @var string
     */
    public $Auftragsart;
    /**
     * The Auftragskennung
     * Meta informations extracted from the WSDL
     * - documentation: Eine von 4 vordefinierten oder eine freie kennung. Kann von der Anfrage-Kennung abweichen und durch einer der 4 vordefinierten Kennungen ersetzt werden (Siehe Pflichtenheft). | Typ fuer alle auf Gebinden und Papier aufgedruckten
     * Kennungen
     * - use: required
     * - pattern: [A-Z0-9+\-_]{1,20}
     * @var string
     */
    public $Auftragskennung;
    /**
     * The Belegdatum
     * Meta informations extracted from the WSDL
     * - documentation: fachlich vom Papierlieferschein
     * - use: required
     * @var string
     */
    public $Belegdatum;
    /**
     * The FehlmengenEnthalten
     * Meta informations extracted from the WSDL
     * - documentation: mind eine Zeile hat Fehlmenge (redundant) -> Kunde ist darauf hinzuweisen wenn Fehlmengen enthalten sind
     * - use: required
     * @var bool
     */
    public $FehlmengenEnthalten;
    /**
     * The Zeile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9999
     * @var \StructType\Zeile[]
     */
    public $Zeile;
    /**
     * The DokumentId
     * Meta informations extracted from the WSDL
     * - documentation: optional PDF-Lieferschein der mit Funktion DokumentAbfragen abrufbar ist. | eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID
     * (Primaerschluessel)
     * - minOccurs: 0
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $DokumentId;
    /**
     * The Lieferzeitpunkt
     * Meta informations extracted from the WSDL
     * - documentation: der vermeintliche Zeitpunkt, wann die Ware in der Apotheke ist (ggf. ungefaehr)
     * - use: optional
     * @var string
     */
    public $Lieferzeitpunkt;
    /**
     * The Tour
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Tour;
    /**
     * Constructor method for Lieferavis
     * @uses Lieferavis::setLieferscheinnummer()
     * @uses Lieferavis::setBarcodeReferenz()
     * @uses Lieferavis::setAuftragsart()
     * @uses Lieferavis::setAuftragskennung()
     * @uses Lieferavis::setBelegdatum()
     * @uses Lieferavis::setFehlmengenEnthalten()
     * @uses Lieferavis::setZeile()
     * @uses Lieferavis::setDokumentId()
     * @uses Lieferavis::setLieferzeitpunkt()
     * @uses Lieferavis::setTour()
     * @param string $lieferscheinnummer
     * @param string $barcodeReferenz
     * @param string $auftragsart
     * @param string $auftragskennung
     * @param string $belegdatum
     * @param bool $fehlmengenEnthalten
     * @param \StructType\Zeile[] $zeile
     * @param string $dokumentId
     * @param string $lieferzeitpunkt
     * @param string $tour
     */
    public function __construct($lieferscheinnummer = null, $barcodeReferenz = null, $auftragsart = null, $auftragskennung = null, $belegdatum = null, $fehlmengenEnthalten = null, array $zeile = array(), $dokumentId = null, $lieferzeitpunkt = null, $tour = null)
    {
        $this
            ->setLieferscheinnummer($lieferscheinnummer)
            ->setBarcodeReferenz($barcodeReferenz)
            ->setAuftragsart($auftragsart)
            ->setAuftragskennung($auftragskennung)
            ->setBelegdatum($belegdatum)
            ->setFehlmengenEnthalten($fehlmengenEnthalten)
            ->setZeile($zeile)
            ->setDokumentId($dokumentId)
            ->setLieferzeitpunkt($lieferzeitpunkt)
            ->setTour($tour);
    }
    /**
     * Get Lieferscheinnummer value
     * @return string
     */
    public function getLieferscheinnummer()
    {
        return $this->Lieferscheinnummer;
    }
    /**
     * Set Lieferscheinnummer value
     * @param string $lieferscheinnummer
     * @return \StructType\Lieferavis
     */
    public function setLieferscheinnummer($lieferscheinnummer = null)
    {
        $this->Lieferscheinnummer = $lieferscheinnummer;
        return $this;
    }
    /**
     * Get BarcodeReferenz value
     * @return string
     */
    public function getBarcodeReferenz()
    {
        return $this->BarcodeReferenz;
    }
    /**
     * Set BarcodeReferenz value
     * @param string $barcodeReferenz
     * @return \StructType\Lieferavis
     */
    public function setBarcodeReferenz($barcodeReferenz = null)
    {
        $this->BarcodeReferenz = $barcodeReferenz;
        return $this;
    }
    /**
     * Get Auftragsart value
     * @return string
     */
    public function getAuftragsart()
    {
        return $this->Auftragsart;
    }
    /**
     * Set Auftragsart value
     * @uses \EnumType\Auftragsart::valueIsValid()
     * @uses \EnumType\Auftragsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $auftragsart
     * @return \StructType\Lieferavis
     */
    public function setAuftragsart($auftragsart = null)
    {
        $this->Auftragsart = $auftragsart;
        return $this;
    }
    /**
     * Get Auftragskennung value
     * @return string
     */
    public function getAuftragskennung()
    {
        return $this->Auftragskennung;
    }
    /**
     * Set Auftragskennung value
     * @param string $auftragskennung
     * @return \StructType\Lieferavis
     */
    public function setAuftragskennung($auftragskennung = null)
    {
        $this->Auftragskennung = $auftragskennung;
        return $this;
    }
    /**
     * Get Belegdatum value
     * @return string
     */
    public function getBelegdatum()
    {
        return $this->Belegdatum;
    }
    /**
     * Set Belegdatum value
     * @param string $belegdatum
     * @return \StructType\Lieferavis
     */
    public function setBelegdatum($belegdatum = null)
    {
        $this->Belegdatum = $belegdatum;
        return $this;
    }
    /**
     * Get FehlmengenEnthalten value
     * @return bool
     */
    public function getFehlmengenEnthalten()
    {
        return $this->FehlmengenEnthalten;
    }
    /**
     * Set FehlmengenEnthalten value
     * @param bool $fehlmengenEnthalten
     * @return \StructType\Lieferavis
     */
    public function setFehlmengenEnthalten($fehlmengenEnthalten = null)
    {
        $this->FehlmengenEnthalten = $fehlmengenEnthalten;
        return $this;
    }
    /**
     * Get Zeile value
     * @return \StructType\Zeile[]|null
     */
    public function getZeile()
    {
        return $this->Zeile;
    }
    /**
     * Set Zeile value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeile[] $zeile
     * @return \StructType\Lieferavis
     */
    public function setZeile(array $zeile = array())
    {
        $this->Zeile = $zeile;
        return $this;
    }
    /**
     * Add item to Zeile value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeile $item
     * @return \StructType\Lieferavis
     */
    public function addToZeile(\StructType\Zeile $item)
    {
        $this->Zeile[] = $item;
        return $this;
    }
    /**
     * Get DokumentId value
     * @return string|null
     */
    public function getDokumentId()
    {
        return $this->DokumentId;
    }
    /**
     * Set DokumentId value
     * @param string $dokumentId
     * @return \StructType\Lieferavis
     */
    public function setDokumentId($dokumentId = null)
    {
        $this->DokumentId = $dokumentId;
        return $this;
    }
    /**
     * Get Lieferzeitpunkt value
     * @return string|null
     */
    public function getLieferzeitpunkt()
    {
        return $this->Lieferzeitpunkt;
    }
    /**
     * Set Lieferzeitpunkt value
     * @param string $lieferzeitpunkt
     * @return \StructType\Lieferavis
     */
    public function setLieferzeitpunkt($lieferzeitpunkt = null)
    {
        $this->Lieferzeitpunkt = $lieferzeitpunkt;
        return $this;
    }
    /**
     * Get Tour value
     * @return string|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param string $tour
     * @return \StructType\Lieferavis
     */
    public function setTour($tour = null)
    {
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Lieferavis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
