<?php

namespace EnumType;

/**
 * This class stands for BestellungDefektgrund EnumType
 * @subpackage Enumerations
 */
class BestellungDefektgrund
{
    /**
     * Constant for value 'KeineAngabe'
     * @return string 'KeineAngabe'
     */
    const VALUE_KEINE_ANGABE = 'KeineAngabe';
    /**
     * Constant for value 'FehltZurzeit'
     * @return string 'FehltZurzeit'
     */
    const VALUE_FEHLT_ZURZEIT = 'FehltZurzeit';
    /**
     * Constant for value 'HerstellerNichtLieferbar'
     * @return string 'HerstellerNichtLieferbar'
     */
    const VALUE_HERSTELLER_NICHT_LIEFERBAR = 'HerstellerNichtLieferbar';
    /**
     * Constant for value 'NurDirekt'
     * @return string 'NurDirekt'
     */
    const VALUE_NUR_DIREKT = 'NurDirekt';
    /**
     * Constant for value 'NichtGefuehrt'
     * @return string 'NichtGefuehrt'
     */
    const VALUE_NICHT_GEFUEHRT = 'NichtGefuehrt';
    /**
     * Constant for value 'ArtikelNrUnbekannt'
     * @return string 'ArtikelNrUnbekannt'
     */
    const VALUE_ARTIKEL_NR_UNBEKANNT = 'ArtikelNrUnbekannt';
    /**
     * Constant for value 'AusserHandel'
     * @return string 'AusserHandel'
     */
    const VALUE_AUSSER_HANDEL = 'AusserHandel';
    /**
     * Constant for value 'KeinBezug'
     * @return string 'KeinBezug'
     */
    const VALUE_KEIN_BEZUG = 'KeinBezug';
    /**
     * Constant for value 'Transportausschluss'
     * @return string 'Transportausschluss'
     */
    const VALUE_TRANSPORTAUSSCHLUSS = 'Transportausschluss';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEINE_ANGABE
     * @uses self::VALUE_FEHLT_ZURZEIT
     * @uses self::VALUE_HERSTELLER_NICHT_LIEFERBAR
     * @uses self::VALUE_NUR_DIREKT
     * @uses self::VALUE_NICHT_GEFUEHRT
     * @uses self::VALUE_ARTIKEL_NR_UNBEKANNT
     * @uses self::VALUE_AUSSER_HANDEL
     * @uses self::VALUE_KEIN_BEZUG
     * @uses self::VALUE_TRANSPORTAUSSCHLUSS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEINE_ANGABE,
            self::VALUE_FEHLT_ZURZEIT,
            self::VALUE_HERSTELLER_NICHT_LIEFERBAR,
            self::VALUE_NUR_DIREKT,
            self::VALUE_NICHT_GEFUEHRT,
            self::VALUE_ARTIKEL_NR_UNBEKANNT,
            self::VALUE_AUSSER_HANDEL,
            self::VALUE_KEIN_BEZUG,
            self::VALUE_TRANSPORTAUSSCHLUSS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
