<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zeile StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reihenfolge ist exakt die Reihenfolge auf dem gedruckten Lieferschein PZN kann in mehreren Zeilen vorkommen | muss mind ein Anteil oder eine Fehlmenge enthalten sein
 * @subpackage Structs
 */
class Zeile extends AbstractStructBase
{
    /**
     * The PZN
     * Meta informations extracted from the WSDL
     * - documentation: kann in mehreren Zeilen vorkommen | PZN oder auch EAN TODO: Restrictions einbauen.
     * - use: required
     * @var int
     */
    public $PZN;
    /**
     * The Anteil
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Anteil[]
     */
    public $Anteil;
    /**
     * The Fehlmenge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Fehlmenge[]
     */
    public $Fehlmenge;
    /**
     * The Artikelbezeichnung
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Artikelbezeichnung;
    /**
     * The GebindeId
     * Meta informations extracted from the WSDL
     * - documentation: bei Auftragsart=Versand Pflicht sonst nicht erlaubt | Typ fuer alle auf Gebinden und Papier aufgedruckten Kennungen
     * - use: optional
     * - pattern: [A-Z0-9+\-_]{1,20}
     * @var string
     */
    public $GebindeId;
    /**
     * Constructor method for Zeile
     * @uses Zeile::setPZN()
     * @uses Zeile::setAnteil()
     * @uses Zeile::setFehlmenge()
     * @uses Zeile::setArtikelbezeichnung()
     * @uses Zeile::setGebindeId()
     * @param int $pZN
     * @param \StructType\Anteil[] $anteil
     * @param \StructType\Fehlmenge[] $fehlmenge
     * @param string $artikelbezeichnung
     * @param string $gebindeId
     */
    public function __construct($pZN = null, array $anteil = array(), array $fehlmenge = array(), $artikelbezeichnung = null, $gebindeId = null)
    {
        $this
            ->setPZN($pZN)
            ->setAnteil($anteil)
            ->setFehlmenge($fehlmenge)
            ->setArtikelbezeichnung($artikelbezeichnung)
            ->setGebindeId($gebindeId);
    }
    /**
     * Get PZN value
     * @return int
     */
    public function getPZN()
    {
        return $this->PZN;
    }
    /**
     * Set PZN value
     * @param int $pZN
     * @return \StructType\Zeile
     */
    public function setPZN($pZN = null)
    {
        // validation for constraint: int
        if (!is_null($pZN) && !is_numeric($pZN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pZN)), __LINE__);
        }
        $this->PZN = $pZN;
        return $this;
    }
    /**
     * Get Anteil value
     * @return \StructType\Anteil[]|null
     */
    public function getAnteil()
    {
        return $this->Anteil;
    }
    /**
     * Set Anteil value
     * @throws \InvalidArgumentException
     * @param \StructType\Anteil[] $anteil
     * @return \StructType\Zeile
     */
    public function setAnteil(array $anteil = array())
    {
        foreach ($anteil as $zeileAnteilItem) {
            // validation for constraint: itemType
            if (!$zeileAnteilItem instanceof \StructType\Anteil) {
                throw new \InvalidArgumentException(sprintf('The Anteil property can only contain items of \StructType\Anteil, "%s" given', is_object($zeileAnteilItem) ? get_class($zeileAnteilItem) : gettype($zeileAnteilItem)), __LINE__);
            }
        }
        $this->Anteil = $anteil;
        return $this;
    }
    /**
     * Add item to Anteil value
     * @throws \InvalidArgumentException
     * @param \StructType\Anteil $item
     * @return \StructType\Zeile
     */
    public function addToAnteil(\StructType\Anteil $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Anteil) {
            throw new \InvalidArgumentException(sprintf('The Anteil property can only contain items of \StructType\Anteil, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Anteil[] = $item;
        return $this;
    }
    /**
     * Get Fehlmenge value
     * @return \StructType\Fehlmenge[]|null
     */
    public function getFehlmenge()
    {
        return $this->Fehlmenge;
    }
    /**
     * Set Fehlmenge value
     * @throws \InvalidArgumentException
     * @param \StructType\Fehlmenge[] $fehlmenge
     * @return \StructType\Zeile
     */
    public function setFehlmenge(array $fehlmenge = array())
    {
        foreach ($fehlmenge as $zeileFehlmengeItem) {
            // validation for constraint: itemType
            if (!$zeileFehlmengeItem instanceof \StructType\Fehlmenge) {
                throw new \InvalidArgumentException(sprintf('The Fehlmenge property can only contain items of \StructType\Fehlmenge, "%s" given', is_object($zeileFehlmengeItem) ? get_class($zeileFehlmengeItem) : gettype($zeileFehlmengeItem)), __LINE__);
            }
        }
        $this->Fehlmenge = $fehlmenge;
        return $this;
    }
    /**
     * Add item to Fehlmenge value
     * @throws \InvalidArgumentException
     * @param \StructType\Fehlmenge $item
     * @return \StructType\Zeile
     */
    public function addToFehlmenge(\StructType\Fehlmenge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fehlmenge) {
            throw new \InvalidArgumentException(sprintf('The Fehlmenge property can only contain items of \StructType\Fehlmenge, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fehlmenge[] = $item;
        return $this;
    }
    /**
     * Get Artikelbezeichnung value
     * @return string|null
     */
    public function getArtikelbezeichnung()
    {
        return $this->Artikelbezeichnung;
    }
    /**
     * Set Artikelbezeichnung value
     * @param string $artikelbezeichnung
     * @return \StructType\Zeile
     */
    public function setArtikelbezeichnung($artikelbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($artikelbezeichnung) && !is_string($artikelbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artikelbezeichnung)), __LINE__);
        }
        $this->Artikelbezeichnung = $artikelbezeichnung;
        return $this;
    }
    /**
     * Get GebindeId value
     * @return string|null
     */
    public function getGebindeId()
    {
        return $this->GebindeId;
    }
    /**
     * Set GebindeId value
     * @param string $gebindeId
     * @return \StructType\Zeile
     */
    public function setGebindeId($gebindeId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gebindeId) && !preg_match('/[A-Z0-9+\\-_]{1,20}/', $gebindeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9+\-_]{1,20}", "%s" given', var_export($gebindeId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gebindeId) && !is_string($gebindeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gebindeId)), __LINE__);
        }
        $this->GebindeId = $gebindeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Zeile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
