<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerfuegbarkeitsanfrageEinzelneAntwort StructType
 * Meta informations extracted from the WSDL
 * - documentation: Die Struktur (Artikel) bezueglich Mengen muss zwischen Anfrage und Antwort identisch sein
 * @subpackage Structs
 */
class VerfuegbarkeitsanfrageEinzelneAntwort extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The RTyp
     * Meta informations extracted from the WSDL
     * - documentation: Legt den Typ der Rueckmeldung fest
     * - use: required
     * @var string
     */
    public $RTyp;
    /**
     * The Artikel
     * Meta informations extracted from the WSDL
     * - documentation: Rueckmeldung fuer alle angefragten Artikel
     * - maxOccurs: 50
     * @var \StructType\VerfuegbarkeitsantwortArtikel[]
     */
    public $Artikel;
    /**
     * Constructor method for VerfuegbarkeitsanfrageEinzelneAntwort
     * @uses VerfuegbarkeitsanfrageEinzelneAntwort::setId()
     * @uses VerfuegbarkeitsanfrageEinzelneAntwort::setRTyp()
     * @uses VerfuegbarkeitsanfrageEinzelneAntwort::setArtikel()
     * @param string $id
     * @param string $rTyp
     * @param \StructType\VerfuegbarkeitsantwortArtikel[] $artikel
     */
    public function __construct($id = null, $rTyp = null, array $artikel = array())
    {
        $this
            ->setId($id)
            ->setRTyp($rTyp)
            ->setArtikel($artikel);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\VerfuegbarkeitsanfrageEinzelneAntwort
     */
    public function setId($id = null)
    {
        // validation for constraint: length
        if ((is_scalar($id) && strlen($id) !== 36) || (is_array($id) && count($id) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RTyp value
     * @return string
     */
    public function getRTyp()
    {
        return $this->RTyp;
    }
    /**
     * Set RTyp value
     * @uses \EnumType\VerfuegbarkeitTyp::valueIsValid()
     * @uses \EnumType\VerfuegbarkeitTyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rTyp
     * @return \StructType\VerfuegbarkeitsanfrageEinzelneAntwort
     */
    public function setRTyp($rTyp = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VerfuegbarkeitTyp::valueIsValid($rTyp)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rTyp, implode(', ', \EnumType\VerfuegbarkeitTyp::getValidValues())), __LINE__);
        }
        $this->RTyp = $rTyp;
        return $this;
    }
    /**
     * Get Artikel value
     * @return \StructType\VerfuegbarkeitsantwortArtikel[]|null
     */
    public function getArtikel()
    {
        return $this->Artikel;
    }
    /**
     * Set Artikel value
     * @throws \InvalidArgumentException
     * @param \StructType\VerfuegbarkeitsantwortArtikel[] $artikel
     * @return \StructType\VerfuegbarkeitsanfrageEinzelneAntwort
     */
    public function setArtikel(array $artikel = array())
    {
        foreach ($artikel as $verfuegbarkeitsanfrageEinzelneAntwortArtikelItem) {
            // validation for constraint: itemType
            if (!$verfuegbarkeitsanfrageEinzelneAntwortArtikelItem instanceof \StructType\VerfuegbarkeitsantwortArtikel) {
                throw new \InvalidArgumentException(sprintf('The Artikel property can only contain items of \StructType\VerfuegbarkeitsantwortArtikel, "%s" given', is_object($verfuegbarkeitsanfrageEinzelneAntwortArtikelItem) ? get_class($verfuegbarkeitsanfrageEinzelneAntwortArtikelItem) : gettype($verfuegbarkeitsanfrageEinzelneAntwortArtikelItem)), __LINE__);
            }
        }
        $this->Artikel = $artikel;
        return $this;
    }
    /**
     * Add item to Artikel value
     * @throws \InvalidArgumentException
     * @param \StructType\VerfuegbarkeitsantwortArtikel $item
     * @return \StructType\VerfuegbarkeitsanfrageEinzelneAntwort
     */
    public function addToArtikel(\StructType\VerfuegbarkeitsantwortArtikel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VerfuegbarkeitsantwortArtikel) {
            throw new \InvalidArgumentException(sprintf('The Artikel property can only contain items of \StructType\VerfuegbarkeitsantwortArtikel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Artikel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerfuegbarkeitsanfrageEinzelneAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
