<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerfuegbarkeitsanfrageEinzelne StructType
 * @subpackage Structs
 */
class VerfuegbarkeitsanfrageEinzelne extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The Artikel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 50
     * @var \StructType\Artikel[]
     */
    public $Artikel;
    /**
     * Constructor method for VerfuegbarkeitsanfrageEinzelne
     * @uses VerfuegbarkeitsanfrageEinzelne::setId()
     * @uses VerfuegbarkeitsanfrageEinzelne::setArtikel()
     * @param string $id
     * @param \StructType\Artikel[] $artikel
     */
    public function __construct($id = null, array $artikel = array())
    {
        $this
            ->setId($id)
            ->setArtikel($artikel);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\VerfuegbarkeitsanfrageEinzelne
     */
    public function setId($id = null)
    {
        // validation for constraint: length
        if ((is_scalar($id) && strlen($id) !== 36) || (is_array($id) && count($id) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Artikel value
     * @return \StructType\Artikel[]|null
     */
    public function getArtikel()
    {
        return $this->Artikel;
    }
    /**
     * Set Artikel value
     * @throws \InvalidArgumentException
     * @param \StructType\Artikel[] $artikel
     * @return \StructType\VerfuegbarkeitsanfrageEinzelne
     */
    public function setArtikel(array $artikel = array())
    {
        foreach ($artikel as $verfuegbarkeitsanfrageEinzelneArtikelItem) {
            // validation for constraint: itemType
            if (!$verfuegbarkeitsanfrageEinzelneArtikelItem instanceof \StructType\Artikel) {
                throw new \InvalidArgumentException(sprintf('The Artikel property can only contain items of \StructType\Artikel, "%s" given', is_object($verfuegbarkeitsanfrageEinzelneArtikelItem) ? get_class($verfuegbarkeitsanfrageEinzelneArtikelItem) : gettype($verfuegbarkeitsanfrageEinzelneArtikelItem)), __LINE__);
            }
        }
        $this->Artikel = $artikel;
        return $this;
    }
    /**
     * Add item to Artikel value
     * @throws \InvalidArgumentException
     * @param \StructType\Artikel $item
     * @return \StructType\VerfuegbarkeitsanfrageEinzelne
     */
    public function addToArtikel(\StructType\Artikel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Artikel) {
            throw new \InvalidArgumentException(sprintf('The Artikel property can only contain items of \StructType\Artikel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Artikel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerfuegbarkeitsanfrageEinzelne
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
