<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerfuegbarkeitsanfrageBulkAntwort StructType
 * @subpackage Structs
 */
class VerfuegbarkeitsanfrageBulkAntwort extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The Pzn
     * Meta informations extracted from the WSDL
     * - documentation: Liste mit verfuegbaren PZNs. Nicht verfuegbare PZNs ergeben sich aus der Differenz zur Anfrage. (aus Gruenden der Performance/Traffic) | PZN oder auch EAN TODO: Restrictions einbauen.
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var int[]
     */
    public $Pzn;
    /**
     * Constructor method for VerfuegbarkeitsanfrageBulkAntwort
     * @uses VerfuegbarkeitsanfrageBulkAntwort::setId()
     * @uses VerfuegbarkeitsanfrageBulkAntwort::setPzn()
     * @param string $id
     * @param int[] $pzn
     */
    public function __construct($id = null, array $pzn = array())
    {
        $this
            ->setId($id)
            ->setPzn($pzn);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\VerfuegbarkeitsanfrageBulkAntwort
     */
    public function setId($id = null)
    {
        // validation for constraint: length
        if ((is_scalar($id) && strlen($id) !== 36) || (is_array($id) && count($id) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Pzn value
     * @return int[]|null
     */
    public function getPzn()
    {
        return $this->Pzn;
    }
    /**
     * Set Pzn value
     * @throws \InvalidArgumentException
     * @param int[] $pzn
     * @return \StructType\VerfuegbarkeitsanfrageBulkAntwort
     */
    public function setPzn(array $pzn = array())
    {
        foreach ($pzn as $verfuegbarkeitsanfrageBulkAntwortPznItem) {
            // validation for constraint: itemType
            if (!is_numeric($verfuegbarkeitsanfrageBulkAntwortPznItem)) {
                throw new \InvalidArgumentException(sprintf('The Pzn property can only contain items of long, "%s" given', is_object($verfuegbarkeitsanfrageBulkAntwortPznItem) ? get_class($verfuegbarkeitsanfrageBulkAntwortPznItem) : gettype($verfuegbarkeitsanfrageBulkAntwortPznItem)), __LINE__);
            }
        }
        $this->Pzn = $pzn;
        return $this;
    }
    /**
     * Add item to Pzn value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\VerfuegbarkeitsanfrageBulkAntwort
     */
    public function addToPzn($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The Pzn property can only contain items of long, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Pzn[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerfuegbarkeitsanfrageBulkAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
