<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerfuegbarkeitsanfrageBulk StructType
 * @subpackage Structs
 */
class VerfuegbarkeitsanfrageBulk extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The Pzn
     * Meta informations extracted from the WSDL
     * - documentation: definiert maximal 10000 konkrete PZNs, zu denen einen Abfrage erfolgen soll. keine doppelten PZNs erlaubt | PZN oder auch EAN TODO: Restrictions einbauen.
     * - maxOccurs: 10000
     * @var int[]
     */
    public $Pzn;
    /**
     * The PznBlock
     * Meta informations extracted from the WSDL
     * - documentation: Start PZN eines 100.000-Blocks von PZNs. Diese PZN muss auf 5 Nullen enden! (damit das Cachen auf GH-seite einfacher wird) Achtung: Wegen den Pruefziffern und Vergabeloechern sind diese Bloecke nie voll besetzt und in der Antwort
     * kommen weniger Artikel zurueck. Dies sind maximal 10.000 Stueck, in der Regel aber ca. 6-8.000 | PZN oder auch EAN TODO: Restrictions einbauen.
     * @var int
     */
    public $PznBlock;
    /**
     * Constructor method for VerfuegbarkeitsanfrageBulk
     * @uses VerfuegbarkeitsanfrageBulk::setId()
     * @uses VerfuegbarkeitsanfrageBulk::setPzn()
     * @uses VerfuegbarkeitsanfrageBulk::setPznBlock()
     * @param string $id
     * @param int[] $pzn
     * @param int $pznBlock
     */
    public function __construct($id = null, array $pzn = array(), $pznBlock = null)
    {
        $this
            ->setId($id)
            ->setPzn($pzn)
            ->setPznBlock($pznBlock);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\VerfuegbarkeitsanfrageBulk
     */
    public function setId($id = null)
    {
        // validation for constraint: length
        if ((is_scalar($id) && strlen($id) !== 36) || (is_array($id) && count($id) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Pzn value
     * @return int[]|null
     */
    public function getPzn()
    {
        return $this->Pzn;
    }
    /**
     * Set Pzn value
     * @throws \InvalidArgumentException
     * @param int[] $pzn
     * @return \StructType\VerfuegbarkeitsanfrageBulk
     */
    public function setPzn(array $pzn = array())
    {
        foreach ($pzn as $verfuegbarkeitsanfrageBulkPznItem) {
            // validation for constraint: itemType
            if (!is_numeric($verfuegbarkeitsanfrageBulkPznItem)) {
                throw new \InvalidArgumentException(sprintf('The Pzn property can only contain items of long, "%s" given', is_object($verfuegbarkeitsanfrageBulkPznItem) ? get_class($verfuegbarkeitsanfrageBulkPznItem) : gettype($verfuegbarkeitsanfrageBulkPznItem)), __LINE__);
            }
        }
        $this->Pzn = $pzn;
        return $this;
    }
    /**
     * Add item to Pzn value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\VerfuegbarkeitsanfrageBulk
     */
    public function addToPzn($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The Pzn property can only contain items of long, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Pzn[] = $item;
        return $this;
    }
    /**
     * Get PznBlock value
     * @return int|null
     */
    public function getPznBlock()
    {
        return $this->PznBlock;
    }
    /**
     * Set PznBlock value
     * @param int $pznBlock
     * @return \StructType\VerfuegbarkeitsanfrageBulk
     */
    public function setPznBlock($pznBlock = null)
    {
        // validation for constraint: int
        if (!is_null($pznBlock) && !is_numeric($pznBlock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pznBlock)), __LINE__);
        }
        $this->PznBlock = $pznBlock;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerfuegbarkeitsanfrageBulk
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
