<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerfuegbarkeitAnteil StructType
 * @subpackage Structs
 */
class VerfuegbarkeitAnteil extends AbstractStructBase
{
    /**
     * The Menge
     * Meta informations extracted from the WSDL
     * - documentation: die Summe ALLER Mengenfelder = AnfrageMenge
     * - nillable: true
     * - maxInclusive: 99999
     * - minInclusive: 1
     * @var int
     */
    public $Menge;
    /**
     * The Typ
     * @var string
     */
    public $Typ;
    /**
     * The Lieferzeitpunkt
     * Meta informations extracted from the WSDL
     * - documentation: Voraussichtlich! z.B. 1.1.2011 15:00 Uhr Bei Typ=Normal oder Verbund und spezifischer Rueckmeldung muss enweder Lieferzeitpunkt oder Tour gefuellt sein!
     * - nillable: true
     * @var string
     */
    public $Lieferzeitpunkt;
    /**
     * The Tour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: optional Tour oder Lieferzeitpunkt ist Pflicht | optional Angabe zur Tour, mit der die enthaltenen Positionen abgeholt werden. Z.B "Mittagstour am 25.05.2015". Sobald mind. eine Position akzeptiert wird, muss entweder Abholzeitpunkt
     * oder die Tour muessen gefuellt sein, sobald eine Retourenmenge akzeptiert wird. | Beschreibung der Tour z.B. "9 Uhr Tour" oder "Mittagstour" Bei Typ=Normal oder Verbund muss enweder Lieferzeitpunkt oder Tour gefuellt sein! | Beschreibung der Tour
     * z.B. "9 Uhr Tour" oder "Mittagstour" Bei Typ=Normal oder Verbund und spezifischer Rueckmeldung muss enweder Lieferzeitpunkt oder Tour gefuellt sein!
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $Tour;
    /**
     * The Grund
     * Meta informations extracted from the WSDL
     * - documentation: ein definierter Defektgrund Bei Typ=Normal oder Verbund ist der Wert immer "KeineAngabe" , sonst ist bei allen anderen Typen einer der ANDEREN! Werte Pflicht
     * @var string
     */
    public $Grund;
    /**
     * The Tourabweichung
     * Meta informations extracted from the WSDL
     * - documentation: nur bei Typ NORMAL und VERBUND ist true erlaubt; true, wenn wegen BTM oder Kuehlware / Transportausschluss nicht mit der naechsten Tour geliefert werden kann
     * @var bool
     */
    public $Tourabweichung;
    /**
     * Constructor method for VerfuegbarkeitAnteil
     * @uses VerfuegbarkeitAnteil::setMenge()
     * @uses VerfuegbarkeitAnteil::setTyp()
     * @uses VerfuegbarkeitAnteil::setLieferzeitpunkt()
     * @uses VerfuegbarkeitAnteil::setTour()
     * @uses VerfuegbarkeitAnteil::setGrund()
     * @uses VerfuegbarkeitAnteil::setTourabweichung()
     * @param int $menge
     * @param string $typ
     * @param string $lieferzeitpunkt
     * @param string $tour
     * @param string $grund
     * @param bool $tourabweichung
     */
    public function __construct($menge = null, $typ = null, $lieferzeitpunkt = null, $tour = null, $grund = null, $tourabweichung = null)
    {
        $this
            ->setMenge($menge)
            ->setTyp($typ)
            ->setLieferzeitpunkt($lieferzeitpunkt)
            ->setTour($tour)
            ->setGrund($grund)
            ->setTourabweichung($tourabweichung);
    }
    /**
     * Get Menge value
     * @return int|null
     */
    public function getMenge()
    {
        return $this->Menge;
    }
    /**
     * Set Menge value
     * @param int $menge
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setMenge($menge = null)
    {
        // validation for constraint: maxInclusive
        if ($menge > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999, "%s" given', $menge), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($menge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $menge), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($menge) && !is_numeric($menge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($menge)), __LINE__);
        }
        $this->Menge = $menge;
        return $this;
    }
    /**
     * Get Typ value
     * @return string|null
     */
    public function getTyp()
    {
        return $this->Typ;
    }
    /**
     * Set Typ value
     * @uses \EnumType\VerfuegbarkeitRueckmeldungTyp::valueIsValid()
     * @uses \EnumType\VerfuegbarkeitRueckmeldungTyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typ
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setTyp($typ = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VerfuegbarkeitRueckmeldungTyp::valueIsValid($typ)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typ, implode(', ', \EnumType\VerfuegbarkeitRueckmeldungTyp::getValidValues())), __LINE__);
        }
        $this->Typ = $typ;
        return $this;
    }
    /**
     * Get Lieferzeitpunkt value
     * @return string|null
     */
    public function getLieferzeitpunkt()
    {
        return $this->Lieferzeitpunkt;
    }
    /**
     * Set Lieferzeitpunkt value
     * @param string $lieferzeitpunkt
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setLieferzeitpunkt($lieferzeitpunkt = null)
    {
        // validation for constraint: string
        if (!is_null($lieferzeitpunkt) && !is_string($lieferzeitpunkt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lieferzeitpunkt)), __LINE__);
        }
        $this->Lieferzeitpunkt = $lieferzeitpunkt;
        return $this;
    }
    /**
     * Get Tour value
     * @return string|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param string $tour
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setTour($tour = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tour) && strlen($tour) > 80) || (is_array($tour) && count($tour) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($tour) ? strlen($tour) : count($tour)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($tour) && strlen($tour) < 1) || (is_array($tour) && count($tour) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tour) && !is_string($tour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tour)), __LINE__);
        }
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Get Grund value
     * @return string|null
     */
    public function getGrund()
    {
        return $this->Grund;
    }
    /**
     * Set Grund value
     * @uses \EnumType\VerfuegbarkeitDefektgrund::valueIsValid()
     * @uses \EnumType\VerfuegbarkeitDefektgrund::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $grund
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setGrund($grund = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VerfuegbarkeitDefektgrund::valueIsValid($grund)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $grund, implode(', ', \EnumType\VerfuegbarkeitDefektgrund::getValidValues())), __LINE__);
        }
        $this->Grund = $grund;
        return $this;
    }
    /**
     * Get Tourabweichung value
     * @return bool|null
     */
    public function getTourabweichung()
    {
        return $this->Tourabweichung;
    }
    /**
     * Set Tourabweichung value
     * @param bool $tourabweichung
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setTourabweichung($tourabweichung = null)
    {
        // validation for constraint: boolean
        if (!is_null($tourabweichung) && !is_bool($tourabweichung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tourabweichung)), __LINE__);
        }
        $this->Tourabweichung = $tourabweichung;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
