<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for verbindungTesten StructType
 * Meta informations extracted from the WSDL
 * - type: tns:verbindungTesten
 * @subpackage Structs
 */
class VerbindungTesten extends AbstractStructBase
{
    /**
     * The clientSoftwareKennung
     * Meta informations extracted from the WSDL
     * - documentation: Ein Rueckschluss auf die zugrunde liegende Version des Kommunikationsmoduls ist zusaetzlich hilfreich, aber nicht obligatorisch
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $clientSoftwareKennung;
    /**
     * Constructor method for verbindungTesten
     * @uses VerbindungTesten::setClientSoftwareKennung()
     * @param string $clientSoftwareKennung
     */
    public function __construct($clientSoftwareKennung = null)
    {
        $this
            ->setClientSoftwareKennung($clientSoftwareKennung);
    }
    /**
     * Get clientSoftwareKennung value
     * @return string|null
     */
    public function getClientSoftwareKennung()
    {
        return $this->clientSoftwareKennung;
    }
    /**
     * Set clientSoftwareKennung value
     * @param string $clientSoftwareKennung
     * @return \StructType\VerbindungTesten
     */
    public function setClientSoftwareKennung($clientSoftwareKennung = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clientSoftwareKennung) && strlen($clientSoftwareKennung) > 80) || (is_array($clientSoftwareKennung) && count($clientSoftwareKennung) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($clientSoftwareKennung) ? strlen($clientSoftwareKennung) : count($clientSoftwareKennung)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($clientSoftwareKennung) && strlen($clientSoftwareKennung) < 1) || (is_array($clientSoftwareKennung) && count($clientSoftwareKennung) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clientSoftwareKennung) && !is_string($clientSoftwareKennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientSoftwareKennung)), __LINE__);
        }
        $this->clientSoftwareKennung = $clientSoftwareKennung;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerbindungTesten
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
