<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SondertagBestellfenster StructType
 * @subpackage Structs
 */
class SondertagBestellfenster extends AbstractStructBase
{
    /**
     * The Endezeit
     * Meta informations extracted from the WSDL
     * - documentation: Es duerfen nur ganze Minuten angegeben werden! Als technische Reserve zaehlt eine Bestellung noch zum alten Bestellfenster, wenn die Bestelluebertragung beim GH bis zur angegebenen Zeit + 59Sekunden startet. | Es duerfen nur ganze
     * Minuten angegeben werden! Als technische Reserve zaehlt eine Bestellung noch zum alten Bestellfenster, wenn die Bestelluebertragung beim GH bis zur angegebenen Zeit + 59Sekunden startet.
     * - pattern: \d\d:\d\d:00
     * @var string
     */
    public $Endezeit;
    /**
     * The Hauptbestellzeit
     * Meta informations extracted from the WSDL
     * - documentation: Zeitpunkt INNERHALB des Bestellfensters an dem die Hauptbestellung durchgefuehrt werden soll | Es duerfen nur ganze Minuten angegeben werden! Als technische Reserve zaehlt eine Bestellung noch zum alten Bestellfenster, wenn die
     * Bestelluebertragung beim GH bis zur angegebenen Zeit + 59Sekunden startet.
     * - pattern: \d\d:\d\d:00
     * @var string
     */
    public $Hauptbestellzeit;
    /**
     * Constructor method for SondertagBestellfenster
     * @uses SondertagBestellfenster::setEndezeit()
     * @uses SondertagBestellfenster::setHauptbestellzeit()
     * @param string $endezeit
     * @param string $hauptbestellzeit
     */
    public function __construct($endezeit = null, $hauptbestellzeit = null)
    {
        $this
            ->setEndezeit($endezeit)
            ->setHauptbestellzeit($hauptbestellzeit);
    }
    /**
     * Get Endezeit value
     * @return string|null
     */
    public function getEndezeit()
    {
        return $this->Endezeit;
    }
    /**
     * Set Endezeit value
     * @param string $endezeit
     * @return \StructType\SondertagBestellfenster
     */
    public function setEndezeit($endezeit = null)
    {
        // validation for constraint: pattern
        if (is_scalar($endezeit) && !preg_match('/\\d\\d:\\d\\d:00/', $endezeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d\d:\d\d:00", "%s" given', var_export($endezeit, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endezeit) && !is_string($endezeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endezeit)), __LINE__);
        }
        $this->Endezeit = $endezeit;
        return $this;
    }
    /**
     * Get Hauptbestellzeit value
     * @return string|null
     */
    public function getHauptbestellzeit()
    {
        return $this->Hauptbestellzeit;
    }
    /**
     * Set Hauptbestellzeit value
     * @param string $hauptbestellzeit
     * @return \StructType\SondertagBestellfenster
     */
    public function setHauptbestellzeit($hauptbestellzeit = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hauptbestellzeit) && !preg_match('/\\d\\d:\\d\\d:00/', $hauptbestellzeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d\d:\d\d:00", "%s" given', var_export($hauptbestellzeit, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hauptbestellzeit) && !is_string($hauptbestellzeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hauptbestellzeit)), __LINE__);
        }
        $this->Hauptbestellzeit = $hauptbestellzeit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SondertagBestellfenster
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
