<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuecknahmeangebotAntwort StructType
 * Meta informations extracted from the WSDL
 * - documentation: nur die fachliche Anfrage
 * @subpackage Structs
 */
class RuecknahmeangebotAntwort extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The ReferenzId
     * Meta informations extracted from the WSDL
     * - documentation: ID mit der von GH der Empfang der Anfrage bestaetigt wird und die bei spaeterer Kommunikation Tel/Mail/Fax zur Referenzierung benutzt werden kann.
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $ReferenzId;
    /**
     * Constructor method for RuecknahmeangebotAntwort
     * @uses RuecknahmeangebotAntwort::setId()
     * @uses RuecknahmeangebotAntwort::setReferenzId()
     * @param string $id
     * @param string $referenzId
     */
    public function __construct($id = null, $referenzId = null)
    {
        $this
            ->setId($id)
            ->setReferenzId($referenzId);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\RuecknahmeangebotAntwort
     */
    public function setId($id = null)
    {
        // validation for constraint: length
        if ((is_scalar($id) && strlen($id) !== 36) || (is_array($id) && count($id) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ReferenzId value
     * @return string|null
     */
    public function getReferenzId()
    {
        return $this->ReferenzId;
    }
    /**
     * Set ReferenzId value
     * @param string $referenzId
     * @return \StructType\RuecknahmeangebotAntwort
     */
    public function setReferenzId($referenzId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referenzId) && strlen($referenzId) > 80) || (is_array($referenzId) && count($referenzId) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($referenzId) ? strlen($referenzId) : count($referenzId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($referenzId) && strlen($referenzId) < 1) || (is_array($referenzId) && count($referenzId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenzId) && !is_string($referenzId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenzId)), __LINE__);
        }
        $this->ReferenzId = $referenzId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RuecknahmeangebotAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
