<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetourenavisAnfrageType StructType
 * Meta informations extracted from the WSDL
 * - documentation: unverbind. Anfrage zur Beurteilung durch GH
 * @subpackage Structs
 */
class RetourenavisAnfrageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Vom System zu vergebende eindeutige ID zur Referenzierung durch den GH (GUID) | eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID
     * (Primaerschluessel)
     * - use: required
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $ID;
    /**
     * The RetoureSupportID
     * Meta informations extracted from the WSDL
     * - documentation: Ausschliessliche Identifikation fuer Menschen! Dient fuer Rueckfragen beim GH (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $RetoureSupportID;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * @var \StructType\RetourePositionType[]
     */
    public $Position;
    /**
     * Constructor method for RetourenavisAnfrageType
     * @uses RetourenavisAnfrageType::setID()
     * @uses RetourenavisAnfrageType::setRetoureSupportID()
     * @uses RetourenavisAnfrageType::setPosition()
     * @param string $iD
     * @param int $retoureSupportID
     * @param \StructType\RetourePositionType[] $position
     */
    public function __construct($iD = null, $retoureSupportID = null, array $position = array())
    {
        $this
            ->setID($iD)
            ->setRetoureSupportID($retoureSupportID)
            ->setPosition($position);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\RetourenavisAnfrageType
     */
    public function setID($iD = null)
    {
        // validation for constraint: length
        if ((is_scalar($iD) && strlen($iD) !== 36) || (is_array($iD) && count($iD) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iD) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($iD, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get RetoureSupportID value
     * @return int
     */
    public function getRetoureSupportID()
    {
        return $this->RetoureSupportID;
    }
    /**
     * Set RetoureSupportID value
     * @param int $retoureSupportID
     * @return \StructType\RetourenavisAnfrageType
     */
    public function setRetoureSupportID($retoureSupportID = null)
    {
        // validation for constraint: maxInclusive
        if ($retoureSupportID > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999, "%s" given', $retoureSupportID), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($retoureSupportID < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $retoureSupportID), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($retoureSupportID) && !is_numeric($retoureSupportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($retoureSupportID)), __LINE__);
        }
        $this->RetoureSupportID = $retoureSupportID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\RetourePositionType[]|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\RetourePositionType[] $position
     * @return \StructType\RetourenavisAnfrageType
     */
    public function setPosition(array $position = array())
    {
        foreach ($position as $retourenavisAnfrageTypePositionItem) {
            // validation for constraint: itemType
            if (!$retourenavisAnfrageTypePositionItem instanceof \StructType\RetourePositionType) {
                throw new \InvalidArgumentException(sprintf('The Position property can only contain items of \StructType\RetourePositionType, "%s" given', is_object($retourenavisAnfrageTypePositionItem) ? get_class($retourenavisAnfrageTypePositionItem) : gettype($retourenavisAnfrageTypePositionItem)), __LINE__);
            }
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\RetourePositionType $item
     * @return \StructType\RetourenavisAnfrageType
     */
    public function addToPosition(\StructType\RetourePositionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RetourePositionType) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of \StructType\RetourePositionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetourenavisAnfrageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
