<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetourePositionType StructType
 * @subpackage Structs
 */
class RetourePositionType extends AbstractStructBase
{
    /**
     * The PosRefID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PosRefID;
    /**
     * The Lieferscheinnummer
     * Meta informations extracted from the WSDL
     * - documentation: Information fuer GH zur Zuordnung zur damaligen Lieferung
     * - use: required
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [a-zA-Z0-9#+\*[:slash:]\-_]*
     * @var string
     */
    public $Lieferscheinnummer;
    /**
     * The PZN
     * Meta informations extracted from the WSDL
     * - documentation: Eine PZN kann mehrfach vorkommen wegen unterschiedlicher Lieferscheinnummern und Reklamantionsgruende | PZN oder auch EAN TODO: Restrictions einbauen.
     * - use: required
     * @var int
     */
    public $PZN;
    /**
     * The RetourenMenge
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $RetourenMenge;
    /**
     * The Retouregrund
     * Meta informations extracted from the WSDL
     * - documentation: Bestellfehler, Berechnet aber nicht geliefert, Beschaedigt, Verfall zu kurz, Zuviel geliefert
     * - use: required
     * @var string
     */
    public $Retouregrund;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Charge;
    /**
     * The Verfalldatum
     * Meta informations extracted from the WSDL
     * - documentation: optional: Verfalldatum=letzter Tag, wo eine Packung noch benutzbar ist (fuer 11/2016 -> 30.11.2016)
     * - use: optional
     * @var string
     */
    public $Verfalldatum;
    /**
     * Constructor method for RetourePositionType
     * @uses RetourePositionType::setPosRefID()
     * @uses RetourePositionType::setLieferscheinnummer()
     * @uses RetourePositionType::setPZN()
     * @uses RetourePositionType::setRetourenMenge()
     * @uses RetourePositionType::setRetouregrund()
     * @uses RetourePositionType::setCharge()
     * @uses RetourePositionType::setVerfalldatum()
     * @param string $posRefID
     * @param string $lieferscheinnummer
     * @param int $pZN
     * @param string $retourenMenge
     * @param string $retouregrund
     * @param string $charge
     * @param string $verfalldatum
     */
    public function __construct($posRefID = null, $lieferscheinnummer = null, $pZN = null, $retourenMenge = null, $retouregrund = null, $charge = null, $verfalldatum = null)
    {
        $this
            ->setPosRefID($posRefID)
            ->setLieferscheinnummer($lieferscheinnummer)
            ->setPZN($pZN)
            ->setRetourenMenge($retourenMenge)
            ->setRetouregrund($retouregrund)
            ->setCharge($charge)
            ->setVerfalldatum($verfalldatum);
    }
    /**
     * Get PosRefID value
     * @return string
     */
    public function getPosRefID()
    {
        return $this->PosRefID;
    }
    /**
     * Set PosRefID value
     * @param string $posRefID
     * @return \StructType\RetourePositionType
     */
    public function setPosRefID($posRefID = null)
    {
        // validation for constraint: string
        if (!is_null($posRefID) && !is_string($posRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($posRefID)), __LINE__);
        }
        $this->PosRefID = $posRefID;
        return $this;
    }
    /**
     * Get Lieferscheinnummer value
     * @return string
     */
    public function getLieferscheinnummer()
    {
        return $this->Lieferscheinnummer;
    }
    /**
     * Set Lieferscheinnummer value
     * @param string $lieferscheinnummer
     * @return \StructType\RetourePositionType
     */
    public function setLieferscheinnummer($lieferscheinnummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($lieferscheinnummer) && strlen($lieferscheinnummer) > 30) || (is_array($lieferscheinnummer) && count($lieferscheinnummer) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($lieferscheinnummer) ? strlen($lieferscheinnummer) : count($lieferscheinnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($lieferscheinnummer) && strlen($lieferscheinnummer) < 1) || (is_array($lieferscheinnummer) && count($lieferscheinnummer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($lieferscheinnummer) && !preg_match('/[a-zA-Z0-9#+\\*\/\\-_]*/', $lieferscheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-zA-Z0-9#+\*/\-_]*", "%s" given', var_export($lieferscheinnummer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lieferscheinnummer) && !is_string($lieferscheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lieferscheinnummer)), __LINE__);
        }
        $this->Lieferscheinnummer = $lieferscheinnummer;
        return $this;
    }
    /**
     * Get PZN value
     * @return int
     */
    public function getPZN()
    {
        return $this->PZN;
    }
    /**
     * Set PZN value
     * @param int $pZN
     * @return \StructType\RetourePositionType
     */
    public function setPZN($pZN = null)
    {
        // validation for constraint: int
        if (!is_null($pZN) && !is_numeric($pZN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pZN)), __LINE__);
        }
        $this->PZN = $pZN;
        return $this;
    }
    /**
     * Get RetourenMenge value
     * @return string
     */
    public function getRetourenMenge()
    {
        return $this->RetourenMenge;
    }
    /**
     * Set RetourenMenge value
     * @param string $retourenMenge
     * @return \StructType\RetourePositionType
     */
    public function setRetourenMenge($retourenMenge = null)
    {
        // validation for constraint: string
        if (!is_null($retourenMenge) && !is_string($retourenMenge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retourenMenge)), __LINE__);
        }
        $this->RetourenMenge = $retourenMenge;
        return $this;
    }
    /**
     * Get Retouregrund value
     * @return string
     */
    public function getRetouregrund()
    {
        return $this->Retouregrund;
    }
    /**
     * Set Retouregrund value
     * @uses \EnumType\RetoureGrund::valueIsValid()
     * @uses \EnumType\RetoureGrund::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retouregrund
     * @return \StructType\RetourePositionType
     */
    public function setRetouregrund($retouregrund = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetoureGrund::valueIsValid($retouregrund)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retouregrund, implode(', ', \EnumType\RetoureGrund::getValidValues())), __LINE__);
        }
        $this->Retouregrund = $retouregrund;
        return $this;
    }
    /**
     * Get Charge value
     * @return string|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param string $charge
     * @return \StructType\RetourePositionType
     */
    public function setCharge($charge = null)
    {
        // validation for constraint: string
        if (!is_null($charge) && !is_string($charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charge)), __LINE__);
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get Verfalldatum value
     * @return string|null
     */
    public function getVerfalldatum()
    {
        return $this->Verfalldatum;
    }
    /**
     * Set Verfalldatum value
     * @param string $verfalldatum
     * @return \StructType\RetourePositionType
     */
    public function setVerfalldatum($verfalldatum = null)
    {
        // validation for constraint: string
        if (!is_null($verfalldatum) && !is_string($verfalldatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verfalldatum)), __LINE__);
        }
        $this->Verfalldatum = $verfalldatum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetourePositionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
