<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position StructType
 * Meta informations extracted from the WSDL
 * - documentation: Die Reihenfolge der PosRefIDs in der Antwort kann von der Reihenfolge in der Anfrage abweichen. Fuer die Erzeugung eines Retourenscheins sind die Zeilen aber immer aufsteigend nach PosRefID sortiert. | Die Reihenfolge der PosRefIDs
 * in der Antwort kann von der Reihenfolge in der Anfrage abweichen. Fuer die Erzeugung eines Retourenscheins sind die Zeilen aber immer aufsteigend nach PosRefID sortiert.
 * @subpackage Structs
 */
class Position extends RetourePositionType
{
    /**
     * The RetourenAnteilTyp
     * Meta informations extracted from the WSDL
     * - documentation: Ja (Retoure akzeptiert), Nein (LS unbekannt, PZN nicht im LS enthalten, keine Ruecknahme, Rueckgabefrist ueberschritten)
     * - use: required
     * @var string
     */
    public $RetourenAnteilTyp;
    /**
     * Constructor method for Position
     * @uses Position::setRetourenAnteilTyp()
     * @param string $retourenAnteilTyp
     */
    public function __construct($retourenAnteilTyp = null)
    {
        $this
            ->setRetourenAnteilTyp($retourenAnteilTyp);
    }
    /**
     * Get RetourenAnteilTyp value
     * @return string
     */
    public function getRetourenAnteilTyp()
    {
        return $this->RetourenAnteilTyp;
    }
    /**
     * Set RetourenAnteilTyp value
     * @uses \EnumType\RetourenAnteilTypType::valueIsValid()
     * @uses \EnumType\RetourenAnteilTypType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retourenAnteilTyp
     * @return \StructType\Position
     */
    public function setRetourenAnteilTyp($retourenAnteilTyp = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetourenAnteilTypType::valueIsValid($retourenAnteilTyp)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retourenAnteilTyp, implode(', ', \EnumType\RetourenAnteilTypType::getValidValues())), __LINE__);
        }
        $this->RetourenAnteilTyp = $retourenAnteilTyp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Position
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
