<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LieferavisBestaetigenType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bestaetigung des Lieferavis-Empfangs
 * @subpackage Structs
 */
class LieferavisBestaetigenType extends AbstractStructBase
{
    /**
     * The Lieferscheinnummer
     * Meta informations extracted from the WSDL
     * - documentation: fachlich und technischer PK Nummer vom Papierlieferschein der in der Apotheke verarbeitet wurde
     * - maxOccurs: 999
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [a-zA-Z0-9#+\*[:slash:]\-_]*
     * @var string[]
     */
    public $Lieferscheinnummer;
    /**
     * Constructor method for LieferavisBestaetigenType
     * @uses LieferavisBestaetigenType::setLieferscheinnummer()
     * @param string[] $lieferscheinnummer
     */
    public function __construct(array $lieferscheinnummer = array())
    {
        $this
            ->setLieferscheinnummer($lieferscheinnummer);
    }
    /**
     * Get Lieferscheinnummer value
     * @return string[]|null
     */
    public function getLieferscheinnummer()
    {
        return $this->Lieferscheinnummer;
    }
    /**
     * Set Lieferscheinnummer value
     * @throws \InvalidArgumentException
     * @param string[] $lieferscheinnummer
     * @return \StructType\LieferavisBestaetigenType
     */
    public function setLieferscheinnummer(array $lieferscheinnummer = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($lieferscheinnummer) && strlen($lieferscheinnummer) > 30) || (is_array($lieferscheinnummer) && count($lieferscheinnummer) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($lieferscheinnummer) ? strlen($lieferscheinnummer) : count($lieferscheinnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($lieferscheinnummer) && strlen($lieferscheinnummer) < 1) || (is_array($lieferscheinnummer) && count($lieferscheinnummer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($lieferscheinnummer) && !preg_match('/[a-zA-Z0-9#+\\*\/\\-_]*/', $lieferscheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-zA-Z0-9#+\*/\-_]*", "%s" given', var_export($lieferscheinnummer, true)), __LINE__);
        }
        foreach ($lieferscheinnummer as $lieferavisBestaetigenTypeLieferscheinnummerItem) {
            // validation for constraint: itemType
            if (!is_string($lieferavisBestaetigenTypeLieferscheinnummerItem)) {
                throw new \InvalidArgumentException(sprintf('The Lieferscheinnummer property can only contain items of string, "%s" given', is_object($lieferavisBestaetigenTypeLieferscheinnummerItem) ? get_class($lieferavisBestaetigenTypeLieferscheinnummerItem) : gettype($lieferavisBestaetigenTypeLieferscheinnummerItem)), __LINE__);
            }
        }
        $this->Lieferscheinnummer = $lieferscheinnummer;
        return $this;
    }
    /**
     * Add item to Lieferscheinnummer value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LieferavisBestaetigenType
     */
    public function addToLieferscheinnummer($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 30) || (is_array($item) && count($item) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[a-zA-Z0-9#+\\*\/\\-_]*/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-zA-Z0-9#+\*/\-_]*", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Lieferscheinnummer property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Lieferscheinnummer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LieferavisBestaetigenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
