<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LieferavisAbfrageHistAbfrage StructType
 * @subpackage Structs
 */
class LieferavisAbfrageHistAbfrage extends AbstractStructBase
{
    /**
     * The Lieferscheinnummer
     * Meta informations extracted from the WSDL
     * - documentation: fachlich und technischer PK Nummer vom Papierlieferschein
     * - use: optional
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [a-zA-Z0-9#+\*[:slash:]\-_]*
     * @var string
     */
    public $Lieferscheinnummer;
    /**
     * The BarcodeReferenz
     * Meta informations extracted from the WSDL
     * - documentation: fuer Abscannen mit Praefix! (1D oder 2D)
     * - use: optional
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [0-9]*[\*+#_\?][a-zA-Z0-9#+\*[:slash:]\-_\?]*
     * @var string
     */
    public $BarcodeReferenz;
    /**
     * Constructor method for LieferavisAbfrageHistAbfrage
     * @uses LieferavisAbfrageHistAbfrage::setLieferscheinnummer()
     * @uses LieferavisAbfrageHistAbfrage::setBarcodeReferenz()
     * @param string $lieferscheinnummer
     * @param string $barcodeReferenz
     */
    public function __construct($lieferscheinnummer = null, $barcodeReferenz = null)
    {
        $this
            ->setLieferscheinnummer($lieferscheinnummer)
            ->setBarcodeReferenz($barcodeReferenz);
    }
    /**
     * Get Lieferscheinnummer value
     * @return string|null
     */
    public function getLieferscheinnummer()
    {
        return $this->Lieferscheinnummer;
    }
    /**
     * Set Lieferscheinnummer value
     * @param string $lieferscheinnummer
     * @return \StructType\LieferavisAbfrageHistAbfrage
     */
    public function setLieferscheinnummer($lieferscheinnummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($lieferscheinnummer) && strlen($lieferscheinnummer) > 30) || (is_array($lieferscheinnummer) && count($lieferscheinnummer) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($lieferscheinnummer) ? strlen($lieferscheinnummer) : count($lieferscheinnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($lieferscheinnummer) && strlen($lieferscheinnummer) < 1) || (is_array($lieferscheinnummer) && count($lieferscheinnummer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($lieferscheinnummer) && !preg_match('/[a-zA-Z0-9#+\\*\/\\-_]*/', $lieferscheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-zA-Z0-9#+\*/\-_]*", "%s" given', var_export($lieferscheinnummer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lieferscheinnummer) && !is_string($lieferscheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lieferscheinnummer)), __LINE__);
        }
        $this->Lieferscheinnummer = $lieferscheinnummer;
        return $this;
    }
    /**
     * Get BarcodeReferenz value
     * @return string|null
     */
    public function getBarcodeReferenz()
    {
        return $this->BarcodeReferenz;
    }
    /**
     * Set BarcodeReferenz value
     * @param string $barcodeReferenz
     * @return \StructType\LieferavisAbfrageHistAbfrage
     */
    public function setBarcodeReferenz($barcodeReferenz = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($barcodeReferenz) && strlen($barcodeReferenz) > 30) || (is_array($barcodeReferenz) && count($barcodeReferenz) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($barcodeReferenz) ? strlen($barcodeReferenz) : count($barcodeReferenz)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($barcodeReferenz) && strlen($barcodeReferenz) < 1) || (is_array($barcodeReferenz) && count($barcodeReferenz) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($barcodeReferenz) && !preg_match('/[0-9]*[\\*+#_\\?][a-zA-Z0-9#+\\*\/\\-_\\?]*/', $barcodeReferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*[\*+#_\?][a-zA-Z0-9#+\*/\-_\?]*", "%s" given', var_export($barcodeReferenz, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($barcodeReferenz) && !is_string($barcodeReferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcodeReferenz)), __LINE__);
        }
        $this->BarcodeReferenz = $barcodeReferenz;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LieferavisAbfrageHistAbfrage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
