<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DokumentAbfragenAntwort StructType
 * Meta informations extracted from the WSDL
 * - documentation: PDF Dokumente fuer Lieveravis und Retourenavis abfragen
 * @subpackage Structs
 */
class DokumentAbfragenAntwort extends AbstractStructBase
{
    /**
     * The DokumentId
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $DokumentId;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Pdf-Dokument mit der maximalgroesse von 2MB
     * - maxLength: 2097152
     * - minLength: 1
     * @var string
     */
    public $Data;
    /**
     * Constructor method for DokumentAbfragenAntwort
     * @uses DokumentAbfragenAntwort::setDokumentId()
     * @uses DokumentAbfragenAntwort::setData()
     * @param string $dokumentId
     * @param string $data
     */
    public function __construct($dokumentId = null, $data = null)
    {
        $this
            ->setDokumentId($dokumentId)
            ->setData($data);
    }
    /**
     * Get DokumentId value
     * @return string
     */
    public function getDokumentId()
    {
        return $this->DokumentId;
    }
    /**
     * Set DokumentId value
     * @param string $dokumentId
     * @return \StructType\DokumentAbfragenAntwort
     */
    public function setDokumentId($dokumentId = null)
    {
        // validation for constraint: length
        if ((is_scalar($dokumentId) && strlen($dokumentId) !== 36) || (is_array($dokumentId) && count($dokumentId) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($dokumentId) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $dokumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($dokumentId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dokumentId) && !is_string($dokumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dokumentId)), __LINE__);
        }
        $this->DokumentId = $dokumentId;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \StructType\DokumentAbfragenAntwort
     */
    public function setData($data = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($data) && strlen($data) > 2097152) || (is_array($data) && count($data) > 2097152)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2097152 element(s) or a scalar of 2097152 character(s) at most, "%d" length given', is_scalar($data) ? strlen($data) : count($data)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($data) && strlen($data) < 1) || (is_array($data) && count($data) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DokumentAbfragenAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
