<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestellungPosition StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reihenfolge (bez PZN) in der Antwort muss gleich sein! keine doppelten PZNs innerhalb eines Auftrags erlaubt (in gesamter Bestellung schon).
 * @subpackage Structs
 */
class BestellungPosition extends AbstractStructBase
{
    /**
     * The Pzn
     * Meta informations extracted from the WSDL
     * - documentation: in einem Auftrag eine PZN nur einmal | PZN oder auch EAN TODO: Restrictions einbauen.
     * @var int
     */
    public $Pzn;
    /**
     * The Menge
     * Meta informations extracted from the WSDL
     * - maxInclusive: 99999
     * - minInclusive: 1
     * @var int
     */
    public $Menge;
    /**
     * The Liefervorgabe
     * @var string
     */
    public $Liefervorgabe;
    /**
     * Constructor method for BestellungPosition
     * @uses BestellungPosition::setPzn()
     * @uses BestellungPosition::setMenge()
     * @uses BestellungPosition::setLiefervorgabe()
     * @param int $pzn
     * @param int $menge
     * @param string $liefervorgabe
     */
    public function __construct($pzn = null, $menge = null, $liefervorgabe = null)
    {
        $this
            ->setPzn($pzn)
            ->setMenge($menge)
            ->setLiefervorgabe($liefervorgabe);
    }
    /**
     * Get Pzn value
     * @return int|null
     */
    public function getPzn()
    {
        return $this->Pzn;
    }
    /**
     * Set Pzn value
     * @param int $pzn
     * @return \StructType\BestellungPosition
     */
    public function setPzn($pzn = null)
    {
        // validation for constraint: int
        if (!is_null($pzn) && !is_numeric($pzn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pzn)), __LINE__);
        }
        $this->Pzn = $pzn;
        return $this;
    }
    /**
     * Get Menge value
     * @return int|null
     */
    public function getMenge()
    {
        return $this->Menge;
    }
    /**
     * Set Menge value
     * @param int $menge
     * @return \StructType\BestellungPosition
     */
    public function setMenge($menge = null)
    {
        // validation for constraint: maxInclusive
        if ($menge > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999, "%s" given', $menge), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($menge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $menge), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($menge) && !is_numeric($menge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($menge)), __LINE__);
        }
        $this->Menge = $menge;
        return $this;
    }
    /**
     * Get Liefervorgabe value
     * @return string|null
     */
    public function getLiefervorgabe()
    {
        return $this->Liefervorgabe;
    }
    /**
     * Set Liefervorgabe value
     * @uses \EnumType\Liefervorgabe::valueIsValid()
     * @uses \EnumType\Liefervorgabe::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $liefervorgabe
     * @return \StructType\BestellungPosition
     */
    public function setLiefervorgabe($liefervorgabe = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Liefervorgabe::valueIsValid($liefervorgabe)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $liefervorgabe, implode(', ', \EnumType\Liefervorgabe::getValidValues())), __LINE__);
        }
        $this->Liefervorgabe = $liefervorgabe;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestellungPosition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
