<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestellungAuftrag StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reihenfolge in der Antwort muss gleich sein! aber maximal 1000 Positionen in der gesamten Bestellung!
 * @subpackage Structs
 */
class BestellungAuftrag extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The Auftragsart
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Auftragsart;
    /**
     * The Auftragskennung
     * Meta informations extracted from the WSDL
     * - documentation: eine von 4 vordefinierten oder eine freie kennung | Typ fuer alle auf Gebinden und Papier aufgedruckten Kennungen
     * - use: required
     * - pattern: [A-Z0-9+\-_]{1,20}
     * @var string
     */
    public $Auftragskennung;
    /**
     * The AuftragsSupportID
     * Meta informations extracted from the WSDL
     * - documentation: ausschliessliche Identifikation fuer Menschen! Support (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $AuftragsSupportID;
    /**
     * The Positionen
     * Meta informations extracted from the WSDL
     * - documentation: Reihenfolge (bez PZN) in der Antwort darf beliebig sein! keine doppelten PZNs innerhalb eines Auftrags erlaubt (in gesamter Bestellung schon).
     * - maxOccurs: 1000
     * @var \StructType\BestellungPosition[]
     */
    public $Positionen;
    /**
     * The GebindeId
     * Meta informations extracted from the WSDL
     * - documentation: bei Auftragsart=Versand Pflicht sonst nicht erlaubt | Typ fuer alle auf Gebinden und Papier aufgedruckten Kennungen
     * - use: optional
     * - pattern: [A-Z0-9+\-_]{1,20}
     * @var string
     */
    public $GebindeId;
    /**
     * Constructor method for BestellungAuftrag
     * @uses BestellungAuftrag::setId()
     * @uses BestellungAuftrag::setAuftragsart()
     * @uses BestellungAuftrag::setAuftragskennung()
     * @uses BestellungAuftrag::setAuftragsSupportID()
     * @uses BestellungAuftrag::setPositionen()
     * @uses BestellungAuftrag::setGebindeId()
     * @param string $id
     * @param string $auftragsart
     * @param string $auftragskennung
     * @param int $auftragsSupportID
     * @param \StructType\BestellungPosition[] $positionen
     * @param string $gebindeId
     */
    public function __construct($id = null, $auftragsart = null, $auftragskennung = null, $auftragsSupportID = null, array $positionen = array(), $gebindeId = null)
    {
        $this
            ->setId($id)
            ->setAuftragsart($auftragsart)
            ->setAuftragskennung($auftragskennung)
            ->setAuftragsSupportID($auftragsSupportID)
            ->setPositionen($positionen)
            ->setGebindeId($gebindeId);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\BestellungAuftrag
     */
    public function setId($id = null)
    {
        // validation for constraint: length
        if ((is_scalar($id) && strlen($id) !== 36) || (is_array($id) && count($id) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Auftragsart value
     * @return string
     */
    public function getAuftragsart()
    {
        return $this->Auftragsart;
    }
    /**
     * Set Auftragsart value
     * @uses \EnumType\Auftragsart::valueIsValid()
     * @uses \EnumType\Auftragsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $auftragsart
     * @return \StructType\BestellungAuftrag
     */
    public function setAuftragsart($auftragsart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Auftragsart::valueIsValid($auftragsart)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $auftragsart, implode(', ', \EnumType\Auftragsart::getValidValues())), __LINE__);
        }
        $this->Auftragsart = $auftragsart;
        return $this;
    }
    /**
     * Get Auftragskennung value
     * @return string
     */
    public function getAuftragskennung()
    {
        return $this->Auftragskennung;
    }
    /**
     * Set Auftragskennung value
     * @param string $auftragskennung
     * @return \StructType\BestellungAuftrag
     */
    public function setAuftragskennung($auftragskennung = null)
    {
        // validation for constraint: pattern
        if (is_scalar($auftragskennung) && !preg_match('/[A-Z0-9+\\-_]{1,20}/', $auftragskennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9+\-_]{1,20}", "%s" given', var_export($auftragskennung, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($auftragskennung) && !is_string($auftragskennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($auftragskennung)), __LINE__);
        }
        $this->Auftragskennung = $auftragskennung;
        return $this;
    }
    /**
     * Get AuftragsSupportID value
     * @return int
     */
    public function getAuftragsSupportID()
    {
        return $this->AuftragsSupportID;
    }
    /**
     * Set AuftragsSupportID value
     * @param int $auftragsSupportID
     * @return \StructType\BestellungAuftrag
     */
    public function setAuftragsSupportID($auftragsSupportID = null)
    {
        // validation for constraint: maxInclusive
        if ($auftragsSupportID > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999, "%s" given', $auftragsSupportID), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($auftragsSupportID < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $auftragsSupportID), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($auftragsSupportID) && !is_numeric($auftragsSupportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($auftragsSupportID)), __LINE__);
        }
        $this->AuftragsSupportID = $auftragsSupportID;
        return $this;
    }
    /**
     * Get Positionen value
     * @return \StructType\BestellungPosition[]|null
     */
    public function getPositionen()
    {
        return $this->Positionen;
    }
    /**
     * Set Positionen value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungPosition[] $positionen
     * @return \StructType\BestellungAuftrag
     */
    public function setPositionen(array $positionen = array())
    {
        foreach ($positionen as $bestellungAuftragPositionenItem) {
            // validation for constraint: itemType
            if (!$bestellungAuftragPositionenItem instanceof \StructType\BestellungPosition) {
                throw new \InvalidArgumentException(sprintf('The Positionen property can only contain items of \StructType\BestellungPosition, "%s" given', is_object($bestellungAuftragPositionenItem) ? get_class($bestellungAuftragPositionenItem) : gettype($bestellungAuftragPositionenItem)), __LINE__);
            }
        }
        $this->Positionen = $positionen;
        return $this;
    }
    /**
     * Add item to Positionen value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungPosition $item
     * @return \StructType\BestellungAuftrag
     */
    public function addToPositionen(\StructType\BestellungPosition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BestellungPosition) {
            throw new \InvalidArgumentException(sprintf('The Positionen property can only contain items of \StructType\BestellungPosition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Positionen[] = $item;
        return $this;
    }
    /**
     * Get GebindeId value
     * @return string|null
     */
    public function getGebindeId()
    {
        return $this->GebindeId;
    }
    /**
     * Set GebindeId value
     * @param string $gebindeId
     * @return \StructType\BestellungAuftrag
     */
    public function setGebindeId($gebindeId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gebindeId) && !preg_match('/[A-Z0-9+\\-_]{1,20}/', $gebindeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9+\-_]{1,20}", "%s" given', var_export($gebindeId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gebindeId) && !is_string($gebindeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gebindeId)), __LINE__);
        }
        $this->GebindeId = $gebindeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestellungAuftrag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
