<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestellungAntwortPosition StructType
 * @subpackage Structs
 */
class BestellungAntwortPosition extends AbstractStructBase
{
    /**
     * The BestellPzn
     * Meta informations extracted from the WSDL
     * - documentation: PZN oder auch EAN TODO: Restrictions einbauen.
     * @var int
     */
    public $BestellPzn;
    /**
     * The BestellMenge
     * Meta informations extracted from the WSDL
     * - maxInclusive: 99999
     * - minInclusive: 1
     * @var int
     */
    public $BestellMenge;
    /**
     * The BestellLiefervorgabe
     * @var string
     */
    public $BestellLiefervorgabe;
    /**
     * The Substitution
     * Meta informations extracted from the WSDL
     * - documentation: wenn angegeben, wird fuer ALLE Anteile der Substitutionsartikel angenommen (ausser bei Substitutionsgrund "Vorschlag") -> Die Loesung schliesst aus Komplexitaetsgruenden aus, dass man bei Substitution fuer Normallieferung einen
     * Anteil mit und einen anteil ohne Substitution liefern darf!
     * - minOccurs: 0
     * @var \StructType\BestellungSubstitution
     */
    public $Substitution;
    /**
     * The Anteile
     * Meta informations extracted from the WSDL
     * - documentation: maximal 9 Anteile der Rueckmeldung wobei jede Auspraegung von Typ nur 1x benutzt werden darf.
     * - maxOccurs: 9
     * @var \StructType\BestellungAnteil[]
     */
    public $Anteile;
    /**
     * Constructor method for BestellungAntwortPosition
     * @uses BestellungAntwortPosition::setBestellPzn()
     * @uses BestellungAntwortPosition::setBestellMenge()
     * @uses BestellungAntwortPosition::setBestellLiefervorgabe()
     * @uses BestellungAntwortPosition::setSubstitution()
     * @uses BestellungAntwortPosition::setAnteile()
     * @param int $bestellPzn
     * @param int $bestellMenge
     * @param string $bestellLiefervorgabe
     * @param \StructType\BestellungSubstitution $substitution
     * @param \StructType\BestellungAnteil[] $anteile
     */
    public function __construct($bestellPzn = null, $bestellMenge = null, $bestellLiefervorgabe = null, \StructType\BestellungSubstitution $substitution = null, array $anteile = array())
    {
        $this
            ->setBestellPzn($bestellPzn)
            ->setBestellMenge($bestellMenge)
            ->setBestellLiefervorgabe($bestellLiefervorgabe)
            ->setSubstitution($substitution)
            ->setAnteile($anteile);
    }
    /**
     * Get BestellPzn value
     * @return int|null
     */
    public function getBestellPzn()
    {
        return $this->BestellPzn;
    }
    /**
     * Set BestellPzn value
     * @param int $bestellPzn
     * @return \StructType\BestellungAntwortPosition
     */
    public function setBestellPzn($bestellPzn = null)
    {
        // validation for constraint: int
        if (!is_null($bestellPzn) && !is_numeric($bestellPzn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bestellPzn)), __LINE__);
        }
        $this->BestellPzn = $bestellPzn;
        return $this;
    }
    /**
     * Get BestellMenge value
     * @return int|null
     */
    public function getBestellMenge()
    {
        return $this->BestellMenge;
    }
    /**
     * Set BestellMenge value
     * @param int $bestellMenge
     * @return \StructType\BestellungAntwortPosition
     */
    public function setBestellMenge($bestellMenge = null)
    {
        // validation for constraint: maxInclusive
        if ($bestellMenge > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999, "%s" given', $bestellMenge), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($bestellMenge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $bestellMenge), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($bestellMenge) && !is_numeric($bestellMenge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bestellMenge)), __LINE__);
        }
        $this->BestellMenge = $bestellMenge;
        return $this;
    }
    /**
     * Get BestellLiefervorgabe value
     * @return string|null
     */
    public function getBestellLiefervorgabe()
    {
        return $this->BestellLiefervorgabe;
    }
    /**
     * Set BestellLiefervorgabe value
     * @uses \EnumType\Liefervorgabe::valueIsValid()
     * @uses \EnumType\Liefervorgabe::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bestellLiefervorgabe
     * @return \StructType\BestellungAntwortPosition
     */
    public function setBestellLiefervorgabe($bestellLiefervorgabe = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Liefervorgabe::valueIsValid($bestellLiefervorgabe)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bestellLiefervorgabe, implode(', ', \EnumType\Liefervorgabe::getValidValues())), __LINE__);
        }
        $this->BestellLiefervorgabe = $bestellLiefervorgabe;
        return $this;
    }
    /**
     * Get Substitution value
     * @return \StructType\BestellungSubstitution|null
     */
    public function getSubstitution()
    {
        return $this->Substitution;
    }
    /**
     * Set Substitution value
     * @param \StructType\BestellungSubstitution $substitution
     * @return \StructType\BestellungAntwortPosition
     */
    public function setSubstitution(\StructType\BestellungSubstitution $substitution = null)
    {
        $this->Substitution = $substitution;
        return $this;
    }
    /**
     * Get Anteile value
     * @return \StructType\BestellungAnteil[]|null
     */
    public function getAnteile()
    {
        return $this->Anteile;
    }
    /**
     * Set Anteile value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAnteil[] $anteile
     * @return \StructType\BestellungAntwortPosition
     */
    public function setAnteile(array $anteile = array())
    {
        foreach ($anteile as $bestellungAntwortPositionAnteileItem) {
            // validation for constraint: itemType
            if (!$bestellungAntwortPositionAnteileItem instanceof \StructType\BestellungAnteil) {
                throw new \InvalidArgumentException(sprintf('The Anteile property can only contain items of \StructType\BestellungAnteil, "%s" given', is_object($bestellungAntwortPositionAnteileItem) ? get_class($bestellungAntwortPositionAnteileItem) : gettype($bestellungAntwortPositionAnteileItem)), __LINE__);
            }
        }
        $this->Anteile = $anteile;
        return $this;
    }
    /**
     * Add item to Anteile value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAnteil $item
     * @return \StructType\BestellungAntwortPosition
     */
    public function addToAnteile(\StructType\BestellungAnteil $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BestellungAnteil) {
            throw new \InvalidArgumentException(sprintf('The Anteile property can only contain items of \StructType\BestellungAnteil, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Anteile[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestellungAntwortPosition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
