<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestellungAntwort StructType
 * Meta informations extracted from the WSDL
 * - documentation: nur die fachliche Anfrage Die Struktur (Auftraege und Positionen) bezueglich Mengen muss zwischen Anfrage und Antwort identisch sein
 * @subpackage Structs
 */
class BestellungAntwort extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The BestellSupportId
     * Meta informations extracted from the WSDL
     * - documentation: ausschliessliche Identifikation fuer Menschen! Support (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $BestellSupportId;
    /**
     * The NachtBetrieb
     * Meta informations extracted from the WSDL
     * - documentation: Wenn true, darf die Bestellung keine Auftraege enthalten
     * - use: required
     * @var bool
     */
    public $NachtBetrieb;
    /**
     * The Auftraege
     * Meta informations extracted from the WSDL
     * - documentation: Die Reihenfolge der Auftraege in der Antwort darf von der Abfrage-Reihenfolge abweichen. Die Anzahl der Elemente muss identisch sein. Wenn NachtBetrieb = true, Anzahl der Auftraege ist immer 0.
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \StructType\BestellungAntwortAuftrag[]
     */
    public $Auftraege;
    /**
     * Constructor method for BestellungAntwort
     * @uses BestellungAntwort::setId()
     * @uses BestellungAntwort::setBestellSupportId()
     * @uses BestellungAntwort::setNachtBetrieb()
     * @uses BestellungAntwort::setAuftraege()
     * @param string $id
     * @param int $bestellSupportId
     * @param bool $nachtBetrieb
     * @param \StructType\BestellungAntwortAuftrag[] $auftraege
     */
    public function __construct($id = null, $bestellSupportId = null, $nachtBetrieb = null, array $auftraege = array())
    {
        $this
            ->setId($id)
            ->setBestellSupportId($bestellSupportId)
            ->setNachtBetrieb($nachtBetrieb)
            ->setAuftraege($auftraege);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\BestellungAntwort
     */
    public function setId($id = null)
    {
        // validation for constraint: length
        if ((is_scalar($id) && strlen($id) !== 36) || (is_array($id) && count($id) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get BestellSupportId value
     * @return int
     */
    public function getBestellSupportId()
    {
        return $this->BestellSupportId;
    }
    /**
     * Set BestellSupportId value
     * @param int $bestellSupportId
     * @return \StructType\BestellungAntwort
     */
    public function setBestellSupportId($bestellSupportId = null)
    {
        // validation for constraint: maxInclusive
        if ($bestellSupportId > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999, "%s" given', $bestellSupportId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($bestellSupportId < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $bestellSupportId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($bestellSupportId) && !is_numeric($bestellSupportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bestellSupportId)), __LINE__);
        }
        $this->BestellSupportId = $bestellSupportId;
        return $this;
    }
    /**
     * Get NachtBetrieb value
     * @return bool
     */
    public function getNachtBetrieb()
    {
        return $this->NachtBetrieb;
    }
    /**
     * Set NachtBetrieb value
     * @param bool $nachtBetrieb
     * @return \StructType\BestellungAntwort
     */
    public function setNachtBetrieb($nachtBetrieb = null)
    {
        // validation for constraint: boolean
        if (!is_null($nachtBetrieb) && !is_bool($nachtBetrieb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nachtBetrieb)), __LINE__);
        }
        $this->NachtBetrieb = $nachtBetrieb;
        return $this;
    }
    /**
     * Get Auftraege value
     * @return \StructType\BestellungAntwortAuftrag[]|null
     */
    public function getAuftraege()
    {
        return $this->Auftraege;
    }
    /**
     * Set Auftraege value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAntwortAuftrag[] $auftraege
     * @return \StructType\BestellungAntwort
     */
    public function setAuftraege(array $auftraege = array())
    {
        foreach ($auftraege as $bestellungAntwortAuftraegeItem) {
            // validation for constraint: itemType
            if (!$bestellungAntwortAuftraegeItem instanceof \StructType\BestellungAntwortAuftrag) {
                throw new \InvalidArgumentException(sprintf('The Auftraege property can only contain items of \StructType\BestellungAntwortAuftrag, "%s" given', is_object($bestellungAntwortAuftraegeItem) ? get_class($bestellungAntwortAuftraegeItem) : gettype($bestellungAntwortAuftraegeItem)), __LINE__);
            }
        }
        $this->Auftraege = $auftraege;
        return $this;
    }
    /**
     * Add item to Auftraege value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAntwortAuftrag $item
     * @return \StructType\BestellungAntwort
     */
    public function addToAuftraege(\StructType\BestellungAntwortAuftrag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BestellungAntwortAuftrag) {
            throw new \InvalidArgumentException(sprintf('The Auftraege property can only contain items of \StructType\BestellungAntwortAuftrag, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Auftraege[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestellungAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
