<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Artikel StructType
 * Meta informations extracted from the WSDL
 * - documentation: Spezifiziert die Artikeln, zu denen die Verfuegbarkeit abgefragt werden soll keine doppelten PZNs innerhalb erlaubt
 * @subpackage Structs
 */
class Artikel extends ArtikelMenge
{
    /**
     * The Bedarf
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Bedarf;
    /**
     * Constructor method for Artikel
     * @uses Artikel::setBedarf()
     * @param string $bedarf
     */
    public function __construct($bedarf = null)
    {
        $this
            ->setBedarf($bedarf);
    }
    /**
     * Get Bedarf value
     * @return string
     */
    public function getBedarf()
    {
        return $this->Bedarf;
    }
    /**
     * Set Bedarf value
     * @param string $bedarf
     * @return \StructType\Artikel
     */
    public function setBedarf($bedarf = null)
    {
        // validation for constraint: string
        if (!is_null($bedarf) && !is_string($bedarf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bedarf)), __LINE__);
        }
        $this->Bedarf = $bedarf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Artikel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
