<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anteil StructType
 * @subpackage Structs
 */
class Anteil extends AbstractStructBase
{
    /**
     * The MengeGeliefert
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $MengeGeliefert;
    /**
     * The AuftragsID
     * Meta informations extracted from the WSDL
     * - documentation: optional nur fuer NICHT-MSV3Bestellungen (Telefon, Fax, MSV2) Die Befuellung des Feldes erfolgt nur bei eindeutiger Zuordnung – an-dernfalls soll das Feld nicht befuellt werden (Bsp.: Zusammenfueh-rung…) | eindeutige sich nie
     * wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $AuftragsID;
    /**
     * The Packstuecknummer
     * @var string
     */
    public $Packstuecknummer;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Charge;
    /**
     * The Verfalldatum
     * Meta informations extracted from the WSDL
     * - documentation: optional: Verfalldatum=letzter Tag, wo eine Packung noch benutzbar ist (fuer 11/2016 -> 30.11.2016)
     * - use: optional
     * @var string
     */
    public $Verfalldatum;
    /**
     * Constructor method for Anteil
     * @uses Anteil::setMengeGeliefert()
     * @uses Anteil::setAuftragsID()
     * @uses Anteil::setPackstuecknummer()
     * @uses Anteil::setCharge()
     * @uses Anteil::setVerfalldatum()
     * @param string $mengeGeliefert
     * @param string $auftragsID
     * @param string $packstuecknummer
     * @param string $charge
     * @param string $verfalldatum
     */
    public function __construct($mengeGeliefert = null, $auftragsID = null, $packstuecknummer = null, $charge = null, $verfalldatum = null)
    {
        $this
            ->setMengeGeliefert($mengeGeliefert)
            ->setAuftragsID($auftragsID)
            ->setPackstuecknummer($packstuecknummer)
            ->setCharge($charge)
            ->setVerfalldatum($verfalldatum);
    }
    /**
     * Get MengeGeliefert value
     * @return string
     */
    public function getMengeGeliefert()
    {
        return $this->MengeGeliefert;
    }
    /**
     * Set MengeGeliefert value
     * @param string $mengeGeliefert
     * @return \StructType\Anteil
     */
    public function setMengeGeliefert($mengeGeliefert = null)
    {
        // validation for constraint: string
        if (!is_null($mengeGeliefert) && !is_string($mengeGeliefert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mengeGeliefert)), __LINE__);
        }
        $this->MengeGeliefert = $mengeGeliefert;
        return $this;
    }
    /**
     * Get AuftragsID value
     * @return string|null
     */
    public function getAuftragsID()
    {
        return $this->AuftragsID;
    }
    /**
     * Set AuftragsID value
     * @param string $auftragsID
     * @return \StructType\Anteil
     */
    public function setAuftragsID($auftragsID = null)
    {
        // validation for constraint: length
        if ((is_scalar($auftragsID) && strlen($auftragsID) !== 36) || (is_array($auftragsID) && count($auftragsID) !== 36)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($auftragsID) && !preg_match('/([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}/', $auftragsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}", "%s" given', var_export($auftragsID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($auftragsID) && !is_string($auftragsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($auftragsID)), __LINE__);
        }
        $this->AuftragsID = $auftragsID;
        return $this;
    }
    /**
     * Get Packstuecknummer value
     * @return string|null
     */
    public function getPackstuecknummer()
    {
        return $this->Packstuecknummer;
    }
    /**
     * Set Packstuecknummer value
     * @param string $packstuecknummer
     * @return \StructType\Anteil
     */
    public function setPackstuecknummer($packstuecknummer = null)
    {
        // validation for constraint: string
        if (!is_null($packstuecknummer) && !is_string($packstuecknummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packstuecknummer)), __LINE__);
        }
        $this->Packstuecknummer = $packstuecknummer;
        return $this;
    }
    /**
     * Get Charge value
     * @return string|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param string $charge
     * @return \StructType\Anteil
     */
    public function setCharge($charge = null)
    {
        // validation for constraint: string
        if (!is_null($charge) && !is_string($charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charge)), __LINE__);
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get Verfalldatum value
     * @return string|null
     */
    public function getVerfalldatum()
    {
        return $this->Verfalldatum;
    }
    /**
     * Set Verfalldatum value
     * @param string $verfalldatum
     * @return \StructType\Anteil
     */
    public function setVerfalldatum($verfalldatum = null)
    {
        // validation for constraint: string
        if (!is_null($verfalldatum) && !is_string($verfalldatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verfalldatum)), __LINE__);
        }
        $this->Verfalldatum = $verfalldatum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Anteil
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
