<?php

namespace EnumType;

/**
 * This class stands for VertragsdatenTag EnumType
 * @subpackage Enumerations
 */
class VertragsdatenTag
{
    /**
     * Constant for value 'Mo'
     * @return string 'Mo'
     */
    const VALUE_MO = 'Mo';
    /**
     * Constant for value 'Di'
     * @return string 'Di'
     */
    const VALUE_DI = 'Di';
    /**
     * Constant for value 'Mi'
     * @return string 'Mi'
     */
    const VALUE_MI = 'Mi';
    /**
     * Constant for value 'Do'
     * @return string 'Do'
     */
    const VALUE_DO = 'Do';
    /**
     * Constant for value 'Fr'
     * @return string 'Fr'
     */
    const VALUE_FR = 'Fr';
    /**
     * Constant for value 'Sa'
     * @return string 'Sa'
     */
    const VALUE_SA = 'Sa';
    /**
     * Constant for value 'So'
     * @return string 'So'
     */
    const VALUE_SO = 'So';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MO
     * @uses self::VALUE_DI
     * @uses self::VALUE_MI
     * @uses self::VALUE_DO
     * @uses self::VALUE_FR
     * @uses self::VALUE_SA
     * @uses self::VALUE_SO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MO,
            self::VALUE_DI,
            self::VALUE_MI,
            self::VALUE_DO,
            self::VALUE_FR,
            self::VALUE_SA,
            self::VALUE_SO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
