<?php

namespace EnumType;

/**
 * This class stands for VerfuegbarkeitTyp EnumType
 * @subpackage Enumerations
 */
class VerfuegbarkeitTyp
{
    /**
     * Constant for value 'Spezifisch'
     * @return string 'Spezifisch'
     */
    const VALUE_SPEZIFISCH = 'Spezifisch';
    /**
     * Constant for value 'Unspezifisch'
     * @return string 'Unspezifisch'
     */
    const VALUE_UNSPEZIFISCH = 'Unspezifisch';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SPEZIFISCH
     * @uses self::VALUE_UNSPEZIFISCH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SPEZIFISCH,
            self::VALUE_UNSPEZIFISCH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
