<?php

namespace EnumType;

/**
 * This class stands for RetourenAnteilTypType EnumType
 * @subpackage Enumerations
 */
class RetourenAnteilTypType
{
    /**
     * Constant for value 'RetoureAkzeptiert'
     * @return string 'RetoureAkzeptiert'
     */
    const VALUE_RETOURE_AKZEPTIERT = 'RetoureAkzeptiert';
    /**
     * Constant for value 'RetoureAkzeptiertRueckspracheNoetig'
     * @return string 'RetoureAkzeptiertRueckspracheNoetig'
     */
    const VALUE_RETOURE_AKZEPTIERT_RUECKSPRACHE_NOETIG = 'RetoureAkzeptiertRueckspracheNoetig';
    /**
     * Constant for value 'RetoureAkzeptiertKeineRuecksendungNoetig'
     * @return string 'RetoureAkzeptiertKeineRuecksendungNoetig'
     */
    const VALUE_RETOURE_AKZEPTIERT_KEINE_RUECKSENDUNG_NOETIG = 'RetoureAkzeptiertKeineRuecksendungNoetig';
    /**
     * Constant for value 'LieferscheinnummerUnbekannt'
     * @return string 'LieferscheinnummerUnbekannt'
     */
    const VALUE_LIEFERSCHEINNUMMER_UNBEKANNT = 'LieferscheinnummerUnbekannt';
    /**
     * Constant for value 'PznInLieferscheinnummerNichtEnthalten'
     * @return string 'PznInLieferscheinnummerNichtEnthalten'
     */
    const VALUE_PZN_IN_LIEFERSCHEINNUMMER_NICHT_ENTHALTEN = 'PznInLieferscheinnummerNichtEnthalten';
    /**
     * Constant for value 'KeineRuecknahme'
     * @return string 'KeineRuecknahme'
     */
    const VALUE_KEINE_RUECKNAHME = 'KeineRuecknahme';
    /**
     * Constant for value 'RueckgabefristUeberschritten'
     * @return string 'RueckgabefristUeberschritten'
     */
    const VALUE_RUECKGABEFRIST_UEBERSCHRITTEN = 'RueckgabefristUeberschritten';
    /**
     * Constant for value 'MengeUeberschritten'
     * @return string 'MengeUeberschritten'
     */
    const VALUE_MENGE_UEBERSCHRITTEN = 'MengeUeberschritten';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RETOURE_AKZEPTIERT
     * @uses self::VALUE_RETOURE_AKZEPTIERT_RUECKSPRACHE_NOETIG
     * @uses self::VALUE_RETOURE_AKZEPTIERT_KEINE_RUECKSENDUNG_NOETIG
     * @uses self::VALUE_LIEFERSCHEINNUMMER_UNBEKANNT
     * @uses self::VALUE_PZN_IN_LIEFERSCHEINNUMMER_NICHT_ENTHALTEN
     * @uses self::VALUE_KEINE_RUECKNAHME
     * @uses self::VALUE_RUECKGABEFRIST_UEBERSCHRITTEN
     * @uses self::VALUE_MENGE_UEBERSCHRITTEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RETOURE_AKZEPTIERT,
            self::VALUE_RETOURE_AKZEPTIERT_RUECKSPRACHE_NOETIG,
            self::VALUE_RETOURE_AKZEPTIERT_KEINE_RUECKSENDUNG_NOETIG,
            self::VALUE_LIEFERSCHEINNUMMER_UNBEKANNT,
            self::VALUE_PZN_IN_LIEFERSCHEINNUMMER_NICHT_ENTHALTEN,
            self::VALUE_KEINE_RUECKNAHME,
            self::VALUE_RUECKGABEFRIST_UEBERSCHRITTEN,
            self::VALUE_MENGE_UEBERSCHRITTEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
