<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilitatorType StructType
 * @subpackage Structs
 */
class FacilitatorType extends AbstractStructBase
{
    /**
     * The PaymentFacilitatorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentFacilitatorId;
    /**
     * The SubMerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubMerchantId;
    /**
     * The SubMerchantName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubMerchantName;
    /**
     * Constructor method for FacilitatorType
     * @uses FacilitatorType::setPaymentFacilitatorId()
     * @uses FacilitatorType::setSubMerchantId()
     * @uses FacilitatorType::setSubMerchantName()
     * @param string $paymentFacilitatorId
     * @param string $subMerchantId
     * @param string $subMerchantName
     */
    public function __construct($paymentFacilitatorId = null, $subMerchantId = null, $subMerchantName = null)
    {
        $this
            ->setPaymentFacilitatorId($paymentFacilitatorId)
            ->setSubMerchantId($subMerchantId)
            ->setSubMerchantName($subMerchantName);
    }
    /**
     * Get PaymentFacilitatorId value
     * @return string|null
     */
    public function getPaymentFacilitatorId()
    {
        return $this->PaymentFacilitatorId;
    }
    /**
     * Set PaymentFacilitatorId value
     * @param string $paymentFacilitatorId
     * @return \StructType\FacilitatorType
     */
    public function setPaymentFacilitatorId($paymentFacilitatorId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentFacilitatorId) && !is_string($paymentFacilitatorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentFacilitatorId, true), gettype($paymentFacilitatorId)), __LINE__);
        }
        $this->PaymentFacilitatorId = $paymentFacilitatorId;
        return $this;
    }
    /**
     * Get SubMerchantId value
     * @return string|null
     */
    public function getSubMerchantId()
    {
        return $this->SubMerchantId;
    }
    /**
     * Set SubMerchantId value
     * @param string $subMerchantId
     * @return \StructType\FacilitatorType
     */
    public function setSubMerchantId($subMerchantId = null)
    {
        // validation for constraint: string
        if (!is_null($subMerchantId) && !is_string($subMerchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subMerchantId, true), gettype($subMerchantId)), __LINE__);
        }
        $this->SubMerchantId = $subMerchantId;
        return $this;
    }
    /**
     * Get SubMerchantName value
     * @return string|null
     */
    public function getSubMerchantName()
    {
        return $this->SubMerchantName;
    }
    /**
     * Set SubMerchantName value
     * @param string $subMerchantName
     * @return \StructType\FacilitatorType
     */
    public function setSubMerchantName($subMerchantName = null)
    {
        // validation for constraint: string
        if (!is_null($subMerchantName) && !is_string($subMerchantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subMerchantName, true), gettype($subMerchantName)), __LINE__);
        }
        $this->SubMerchantName = $subMerchantName;
        return $this;
    }
}
