<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerType StructType
 * @subpackage Structs
 */
class PassengerType extends AbstractStructBase
{
    /**
     * The Passenger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Passenger;
    /**
     * The TravellerType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TravellerType;
    /**
     * The LoyaltyNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoyaltyNumber;
    /**
     * The LoyaltyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoyaltyType;
    /**
     * The LoyaltyTier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $LoyaltyTier;
    /**
     * Constructor method for PassengerType
     * @uses PassengerType::setPassenger()
     * @uses PassengerType::setTravellerType()
     * @uses PassengerType::setLoyaltyNumber()
     * @uses PassengerType::setLoyaltyType()
     * @uses PassengerType::setLoyaltyTier()
     * @param \StructType\PersonType $passenger
     * @param string $travellerType
     * @param string $loyaltyNumber
     * @param string $loyaltyType
     * @param int $loyaltyTier
     */
    public function __construct(\StructType\PersonType $passenger = null, $travellerType = null, $loyaltyNumber = null, $loyaltyType = null, $loyaltyTier = null)
    {
        $this
            ->setPassenger($passenger)
            ->setTravellerType($travellerType)
            ->setLoyaltyNumber($loyaltyNumber)
            ->setLoyaltyType($loyaltyType)
            ->setLoyaltyTier($loyaltyTier);
    }
    /**
     * Get Passenger value
     * @return \StructType\PersonType
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @param \StructType\PersonType $passenger
     * @return \StructType\PassengerType
     */
    public function setPassenger(\StructType\PersonType $passenger = null)
    {
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Get TravellerType value
     * @return string
     */
    public function getTravellerType()
    {
        return $this->TravellerType;
    }
    /**
     * Set TravellerType value
     * @uses \EnumType\TravellerType::valueIsValid()
     * @uses \EnumType\TravellerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $travellerType
     * @return \StructType\PassengerType
     */
    public function setTravellerType($travellerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TravellerType::valueIsValid($travellerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TravellerType', is_array($travellerType) ? implode(', ', $travellerType) : var_export($travellerType, true), implode(', ', \EnumType\TravellerType::getValidValues())), __LINE__);
        }
        $this->TravellerType = $travellerType;
        return $this;
    }
    /**
     * Get LoyaltyNumber value
     * @return string|null
     */
    public function getLoyaltyNumber()
    {
        return $this->LoyaltyNumber;
    }
    /**
     * Set LoyaltyNumber value
     * @param string $loyaltyNumber
     * @return \StructType\PassengerType
     */
    public function setLoyaltyNumber($loyaltyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyNumber) && !is_string($loyaltyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyNumber, true), gettype($loyaltyNumber)), __LINE__);
        }
        $this->LoyaltyNumber = $loyaltyNumber;
        return $this;
    }
    /**
     * Get LoyaltyType value
     * @return string|null
     */
    public function getLoyaltyType()
    {
        return $this->LoyaltyType;
    }
    /**
     * Set LoyaltyType value
     * @param string $loyaltyType
     * @return \StructType\PassengerType
     */
    public function setLoyaltyType($loyaltyType = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyType) && !is_string($loyaltyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyType, true), gettype($loyaltyType)), __LINE__);
        }
        $this->LoyaltyType = $loyaltyType;
        return $this;
    }
    /**
     * Get LoyaltyTier value
     * @return int|null
     */
    public function getLoyaltyTier()
    {
        return $this->LoyaltyTier;
    }
    /**
     * Set LoyaltyTier value
     * @param int $loyaltyTier
     * @return \StructType\PassengerType
     */
    public function setLoyaltyTier($loyaltyTier = null)
    {
        // validation for constraint: int
        if (!is_null($loyaltyTier) && !(is_int($loyaltyTier) || ctype_digit($loyaltyTier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loyaltyTier, true), gettype($loyaltyTier)), __LINE__);
        }
        $this->LoyaltyTier = $loyaltyTier;
        return $this;
    }
}
