<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VirtualCardType StructType
 * @subpackage Structs
 */
class VirtualCardType extends AbstractStructBase
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 19
     * - maxOccurs: 1
     * - minLength: 13
     * - minOccurs: 1
     * - pattern: [0-9x]+
     * @var string
     */
    public $CardNumber;
    /**
     * The CardExpiryDate
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardExpiryDate;
    /**
     * The Eci
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Eci;
    /**
     * Constructor method for VirtualCardType
     * @uses VirtualCardType::setCardNumber()
     * @uses VirtualCardType::setCardExpiryDate()
     * @uses VirtualCardType::setEci()
     * @param string $cardNumber
     * @param string $cardExpiryDate
     * @param string $eci
     */
    public function __construct($cardNumber = null, $cardExpiryDate = null, $eci = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardExpiryDate($cardExpiryDate)
            ->setEci($eci);
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\VirtualCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($cardNumber) && mb_strlen($cardNumber) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($cardNumber)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($cardNumber) && mb_strlen($cardNumber) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($cardNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9x]+)
        if (!is_null($cardNumber) && !preg_match('/[0-9x]+/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9x]+', var_export($cardNumber, true)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardExpiryDate value
     * @return string
     */
    public function getCardExpiryDate()
    {
        return $this->CardExpiryDate;
    }
    /**
     * Set CardExpiryDate value
     * @param string $cardExpiryDate
     * @return \StructType\VirtualCardType
     */
    public function setCardExpiryDate($cardExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiryDate) && !is_string($cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiryDate, true), gettype($cardExpiryDate)), __LINE__);
        }
        // validation for constraint: pattern(([0][0-9]|[1][0-2])20[0-9]{2})
        if (!is_null($cardExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0][0-9]|[1][0-2])20[0-9]{2}', var_export($cardExpiryDate, true)), __LINE__);
        }
        $this->CardExpiryDate = $cardExpiryDate;
        return $this;
    }
    /**
     * Get Eci value
     * @return string
     */
    public function getEci()
    {
        return $this->Eci;
    }
    /**
     * Set Eci value
     * @param string $eci
     * @return \StructType\VirtualCardType
     */
    public function setEci($eci = null)
    {
        // validation for constraint: string
        if (!is_null($eci) && !is_string($eci)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eci, true), gettype($eci)), __LINE__);
        }
        $this->Eci = $eci;
        return $this;
    }
}
