<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BankAccountType EnumType
 * @subpackage Enumerations
 */
class BankAccountType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Current'
     * @return string 'Current'
     */
    const VALUE_CURRENT = 'Current';
    /**
     * Constant for value 'Savings'
     * @return string 'Savings'
     */
    const VALUE_SAVINGS = 'Savings';
    /**
     * Constant for value 'Transmission'
     * @return string 'Transmission'
     */
    const VALUE_TRANSMISSION = 'Transmission';
    /**
     * Constant for value 'Bond'
     * @return string 'Bond'
     */
    const VALUE_BOND = 'Bond';
    /**
     * Return allowed values
     * @uses self::VALUE_CURRENT
     * @uses self::VALUE_SAVINGS
     * @uses self::VALUE_TRANSMISSION
     * @uses self::VALUE_BOND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CURRENT,
            self::VALUE_SAVINGS,
            self::VALUE_TRANSMISSION,
            self::VALUE_BOND,
        );
    }
}
