<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequencyType StructType
 * @subpackage Structs
 */
class FrequencyType extends AbstractStructBase
{
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Period;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * The Repetition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Repetition;
    /**
     * Constructor method for FrequencyType
     * @uses FrequencyType::setPeriod()
     * @uses FrequencyType::setAmount()
     * @uses FrequencyType::setRepetition()
     * @param string $period
     * @param int $amount
     * @param int $repetition
     */
    public function __construct($period = null, $amount = null, $repetition = null)
    {
        $this
            ->setPeriod($period)
            ->setAmount($amount)
            ->setRepetition($repetition);
    }
    /**
     * Get Period value
     * @return string|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @uses \EnumType\Period::valueIsValid()
     * @uses \EnumType\Period::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $period
     * @return \StructType\FrequencyType
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Period::valueIsValid($period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Period', is_array($period) ? implode(', ', $period) : var_export($period, true), implode(', ', \EnumType\Period::getValidValues())), __LINE__);
        }
        $this->Period = $period;
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\FrequencyType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Repetition value
     * @return int|null
     */
    public function getRepetition()
    {
        return $this->Repetition;
    }
    /**
     * Set Repetition value
     * @param int $repetition
     * @return \StructType\FrequencyType
     */
    public function setRepetition($repetition = null)
    {
        // validation for constraint: int
        if (!is_null($repetition) && !(is_int($repetition) || ctype_digit($repetition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repetition, true), gettype($repetition)), __LINE__);
        }
        $this->Repetition = $repetition;
        return $this;
    }
}
