<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'PayGateAccountType' => '\\StructType\\PayGateAccountType',
            'PaymentType' => '\\StructType\\PaymentType',
            'RiskType' => '\\StructType\\RiskType',
            'PersonType' => '\\StructType\\PersonType',
            'BrowserType' => '\\StructType\\BrowserType',
            'AddressType' => '\\StructType\\AddressType',
            'ShippingDetailsType' => '\\StructType\\ShippingDetailsType',
            'BillingDetailsType' => '\\StructType\\BillingDetailsType',
            'OrderItemType' => '\\StructType\\OrderItemType',
            'OrderType' => '\\StructType\\OrderType',
            'AcquirerInfoType' => '\\StructType\\AcquirerInfoType',
            'PassengerType' => '\\StructType\\PassengerType',
            'FlightLegType' => '\\StructType\\FlightLegType',
            'AirlineBookingDetailsType' => '\\StructType\\AirlineBookingDetailsType',
            'StatusType' => '\\StructType\\StatusType',
            'KeyValueType' => '\\StructType\\KeyValueType',
            'VaultDataType' => '\\StructType\\VaultDataType',
            'RedirectRequestType' => '\\StructType\\RedirectRequestType',
            'RedirectResponseType' => '\\StructType\\RedirectResponseType',
            'InstructionsResponseType' => '\\StructType\\InstructionsResponseType',
            'ThreeDSecureType' => '\\StructType\\ThreeDSecureType',
            'CardPaymentRequestType' => '\\StructType\\CardPaymentRequestType',
            'RecurringType' => '\\StructType\\RecurringType',
            'FrequencyType' => '\\StructType\\FrequencyType',
            'CardPaymentResponseType' => '\\StructType\\CardPaymentResponseType',
            'BankPaymentRequestType' => '\\StructType\\BankPaymentRequestType',
            'BankPaymentResponseType' => '\\StructType\\BankPaymentResponseType',
            'QueryRequestType' => '\\StructType\\QueryRequestType',
            'QueryResponseType' => '\\StructType\\QueryResponseType',
            'SettleRequestType' => '\\StructType\\SettleRequestType',
            'SettleResponseType' => '\\StructType\\SettleResponseType',
            'RefundRequestType' => '\\StructType\\RefundRequestType',
            'RefundResponseType' => '\\StructType\\RefundResponseType',
            'VoidRequestType' => '\\StructType\\VoidRequestType',
            'VoidResponseType' => '\\StructType\\VoidResponseType',
            'WebPaymentRequestType' => '\\StructType\\WebPaymentRequestType',
            'WebPaymentResponseType' => '\\StructType\\WebPaymentResponseType',
            'TokenPaymentRequestType' => '\\StructType\\TokenPaymentRequestType',
            'TokenPaymentResponseType' => '\\StructType\\TokenPaymentResponseType',
            'CardPayoutRequestType' => '\\StructType\\CardPayoutRequestType',
            'CardPayoutResponseType' => '\\StructType\\CardPayoutResponseType',
            'BankPayoutRequestType' => '\\StructType\\BankPayoutRequestType',
            'BankPayoutResponseType' => '\\StructType\\BankPayoutResponseType',
            'WalletPayoutRequestType' => '\\StructType\\WalletPayoutRequestType',
            'WalletPayoutResponseType' => '\\StructType\\WalletPayoutResponseType',
            'CardVaultRequestType' => '\\StructType\\CardVaultRequestType',
            'CardVaultResponseType' => '\\StructType\\CardVaultResponseType',
            'WalletVaultRequestType' => '\\StructType\\WalletVaultRequestType',
            'WalletVaultResponseType' => '\\StructType\\WalletVaultResponseType',
            'LookUpVaultRequestType' => '\\StructType\\LookUpVaultRequestType',
            'LookUpVaultResponseType' => '\\StructType\\LookUpVaultResponseType',
            'DeleteVaultRequestType' => '\\StructType\\DeleteVaultRequestType',
            'DeleteVaultResponseType' => '\\StructType\\DeleteVaultResponseType',
            'PingRequest' => '\\StructType\\PingRequest',
            'PingResponse' => '\\StructType\\PingResponse',
            'SinglePaymentRequest' => '\\StructType\\SinglePaymentRequest',
            'SinglePaymentResponse' => '\\StructType\\SinglePaymentResponse',
            'SinglePayoutRequest' => '\\StructType\\SinglePayoutRequest',
            'SinglePayoutResponse' => '\\StructType\\SinglePayoutResponse',
            'SingleFollowUpRequest' => '\\StructType\\SingleFollowUpRequest',
            'SingleFollowUpResponse' => '\\StructType\\SingleFollowUpResponse',
            'SingleVaultRequest' => '\\StructType\\SingleVaultRequest',
            'SingleVaultResponse' => '\\StructType\\SingleVaultResponse',
        );
    }
}
