<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SinglePayoutResponse StructType
 * @subpackage Structs
 */
class SinglePayoutResponse extends AbstractStructBase
{
    /**
     * The CardPayoutResponse
     * Meta information extracted from the WSDL
     * - choice: CardPayoutResponse | BankPayoutResponse | WalletPayoutResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CardPayoutResponseType
     */
    public $CardPayoutResponse;
    /**
     * The BankPayoutResponse
     * Meta information extracted from the WSDL
     * - choice: CardPayoutResponse | BankPayoutResponse | WalletPayoutResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\BankPayoutResponseType
     */
    public $BankPayoutResponse;
    /**
     * The WalletPayoutResponse
     * Meta information extracted from the WSDL
     * - choice: CardPayoutResponse | BankPayoutResponse | WalletPayoutResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\WalletPayoutResponseType
     */
    public $WalletPayoutResponse;
    /**
     * Constructor method for SinglePayoutResponse
     * @uses SinglePayoutResponse::setCardPayoutResponse()
     * @uses SinglePayoutResponse::setBankPayoutResponse()
     * @uses SinglePayoutResponse::setWalletPayoutResponse()
     * @param \StructType\CardPayoutResponseType $cardPayoutResponse
     * @param \StructType\BankPayoutResponseType $bankPayoutResponse
     * @param \StructType\WalletPayoutResponseType $walletPayoutResponse
     */
    public function __construct(\StructType\CardPayoutResponseType $cardPayoutResponse = null, \StructType\BankPayoutResponseType $bankPayoutResponse = null, \StructType\WalletPayoutResponseType $walletPayoutResponse = null)
    {
        $this
            ->setCardPayoutResponse($cardPayoutResponse)
            ->setBankPayoutResponse($bankPayoutResponse)
            ->setWalletPayoutResponse($walletPayoutResponse);
    }
    /**
     * Get CardPayoutResponse value
     * @return \StructType\CardPayoutResponseType|null
     */
    public function getCardPayoutResponse()
    {
        return isset($this->CardPayoutResponse) ? $this->CardPayoutResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardPayoutResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardPayoutResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardPayoutResponseForChoiceConstraintsFromSetCardPayoutResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankPayoutResponse',
            'WalletPayoutResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardPayoutResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: CardPayoutResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardPayoutResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CardPayoutResponseType $cardPayoutResponse
     * @return \StructType\SinglePayoutResponse
     */
    public function setCardPayoutResponse(\StructType\CardPayoutResponseType $cardPayoutResponse = null)
    {
        // validation for constraint: choice(CardPayoutResponse, BankPayoutResponse, WalletPayoutResponse)
        if ('' !== ($cardPayoutResponseChoiceErrorMessage = self::validateCardPayoutResponseForChoiceConstraintsFromSetCardPayoutResponse($cardPayoutResponse))) {
            throw new \InvalidArgumentException($cardPayoutResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardPayoutResponse) || (is_array($cardPayoutResponse) && empty($cardPayoutResponse))) {
            unset($this->CardPayoutResponse);
        } else {
            $this->CardPayoutResponse = $cardPayoutResponse;
        }
        return $this;
    }
    /**
     * Get BankPayoutResponse value
     * @return \StructType\BankPayoutResponseType|null
     */
    public function getBankPayoutResponse()
    {
        return isset($this->BankPayoutResponse) ? $this->BankPayoutResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankPayoutResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankPayoutResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankPayoutResponseForChoiceConstraintsFromSetBankPayoutResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPayoutResponse',
            'WalletPayoutResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankPayoutResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: BankPayoutResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankPayoutResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankPayoutResponseType $bankPayoutResponse
     * @return \StructType\SinglePayoutResponse
     */
    public function setBankPayoutResponse(\StructType\BankPayoutResponseType $bankPayoutResponse = null)
    {
        // validation for constraint: choice(CardPayoutResponse, BankPayoutResponse, WalletPayoutResponse)
        if ('' !== ($bankPayoutResponseChoiceErrorMessage = self::validateBankPayoutResponseForChoiceConstraintsFromSetBankPayoutResponse($bankPayoutResponse))) {
            throw new \InvalidArgumentException($bankPayoutResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankPayoutResponse) || (is_array($bankPayoutResponse) && empty($bankPayoutResponse))) {
            unset($this->BankPayoutResponse);
        } else {
            $this->BankPayoutResponse = $bankPayoutResponse;
        }
        return $this;
    }
    /**
     * Get WalletPayoutResponse value
     * @return \StructType\WalletPayoutResponseType|null
     */
    public function getWalletPayoutResponse()
    {
        return isset($this->WalletPayoutResponse) ? $this->WalletPayoutResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWalletPayoutResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWalletPayoutResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWalletPayoutResponseForChoiceConstraintsFromSetWalletPayoutResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPayoutResponse',
            'BankPayoutResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property WalletPayoutResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: WalletPayoutResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set WalletPayoutResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WalletPayoutResponseType $walletPayoutResponse
     * @return \StructType\SinglePayoutResponse
     */
    public function setWalletPayoutResponse(\StructType\WalletPayoutResponseType $walletPayoutResponse = null)
    {
        // validation for constraint: choice(CardPayoutResponse, BankPayoutResponse, WalletPayoutResponse)
        if ('' !== ($walletPayoutResponseChoiceErrorMessage = self::validateWalletPayoutResponseForChoiceConstraintsFromSetWalletPayoutResponse($walletPayoutResponse))) {
            throw new \InvalidArgumentException($walletPayoutResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($walletPayoutResponse) || (is_array($walletPayoutResponse) && empty($walletPayoutResponse))) {
            unset($this->WalletPayoutResponse);
        } else {
            $this->WalletPayoutResponse = $walletPayoutResponse;
        }
        return $this;
    }
}
