<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardPaymentRequestType StructType
 * @subpackage Structs
 */
class CardPaymentRequestType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - choice: CardNumber | CardExpiryDate | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 19
     * - maxOccurs: 1
     * - minLength: 13
     * - minOccurs: 1
     * - pattern: [0-9x]+
     * @var string
     */
    public $CardNumber;
    /**
     * The VaultId
     * Meta information extracted from the WSDL
     * - choice: CardNumber | CardExpiryDate | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VaultId;
    /**
     * The CVV
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 3
     * - minOccurs: 1
     * - pattern: [0-9]+
     * @var string
     */
    public $CVV;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The CardExpiryDate
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - choice: CardNumber | CardExpiryDate | VaultId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardExpiryDate;
    /**
     * The CardIssueDate
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0][0-9]|[1][0-2])20[0-9]{2}
     * @var string
     */
    public $CardIssueDate;
    /**
     * The CardIssueNumber
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: [0-9]+
     * @var string
     */
    public $CardIssueNumber;
    /**
     * The Vault
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Vault;
    /**
     * The BudgetPeriod
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: [0-9]+
     * @var string
     */
    public $BudgetPeriod;
    /**
     * The Redirect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectRequestType
     */
    public $Redirect;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The AcquirerInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AcquirerInfoType
     */
    public $AcquirerInfo;
    /**
     * The ThreeDSecure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ThreeDSecureType
     */
    public $ThreeDSecure;
    /**
     * The Risk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RiskType
     */
    public $Risk;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * The BillingDescriptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * Constructor method for CardPaymentRequestType
     * @uses CardPaymentRequestType::setCustomer()
     * @uses CardPaymentRequestType::setCardNumber()
     * @uses CardPaymentRequestType::setVaultId()
     * @uses CardPaymentRequestType::setCVV()
     * @uses CardPaymentRequestType::setAccount()
     * @uses CardPaymentRequestType::setCardExpiryDate()
     * @uses CardPaymentRequestType::setCardIssueDate()
     * @uses CardPaymentRequestType::setCardIssueNumber()
     * @uses CardPaymentRequestType::setVault()
     * @uses CardPaymentRequestType::setBudgetPeriod()
     * @uses CardPaymentRequestType::setRedirect()
     * @uses CardPaymentRequestType::setOrder()
     * @uses CardPaymentRequestType::setAcquirerInfo()
     * @uses CardPaymentRequestType::setThreeDSecure()
     * @uses CardPaymentRequestType::setRisk()
     * @uses CardPaymentRequestType::setUserDefinedFields()
     * @uses CardPaymentRequestType::setBillingDescriptor()
     * @param \StructType\PersonType $customer
     * @param string $cardNumber
     * @param string $vaultId
     * @param string $cVV
     * @param \StructType\PayGateAccountType $account
     * @param string $cardExpiryDate
     * @param string $cardIssueDate
     * @param string $cardIssueNumber
     * @param bool $vault
     * @param string $budgetPeriod
     * @param \StructType\RedirectRequestType $redirect
     * @param \StructType\OrderType $order
     * @param \StructType\AcquirerInfoType $acquirerInfo
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @param \StructType\RiskType $risk
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @param string $billingDescriptor
     */
    public function __construct(\StructType\PersonType $customer = null, $cardNumber = null, $vaultId = null, $cVV = null, \StructType\PayGateAccountType $account = null, $cardExpiryDate = null, $cardIssueDate = null, $cardIssueNumber = null, $vault = false, $budgetPeriod = null, \StructType\RedirectRequestType $redirect = null, \StructType\OrderType $order = null, \StructType\AcquirerInfoType $acquirerInfo = null, \StructType\ThreeDSecureType $threeDSecure = null, \StructType\RiskType $risk = null, array $userDefinedFields = array(), $billingDescriptor = null)
    {
        $this
            ->setCustomer($customer)
            ->setCardNumber($cardNumber)
            ->setVaultId($vaultId)
            ->setCVV($cVV)
            ->setAccount($account)
            ->setCardExpiryDate($cardExpiryDate)
            ->setCardIssueDate($cardIssueDate)
            ->setCardIssueNumber($cardIssueNumber)
            ->setVault($vault)
            ->setBudgetPeriod($budgetPeriod)
            ->setRedirect($redirect)
            ->setOrder($order)
            ->setAcquirerInfo($acquirerInfo)
            ->setThreeDSecure($threeDSecure)
            ->setRisk($risk)
            ->setUserDefinedFields($userDefinedFields)
            ->setBillingDescriptor($billingDescriptor);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\CardPaymentRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardNumberForChoiceConstraintsFromSetCardNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardExpiryDate',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: CardNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $cardNumber
     * @return \StructType\CardPaymentRequestType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        // validation for constraint: choice(CardNumber, CardExpiryDate, VaultId)
        if ('' !== ($cardNumberChoiceErrorMessage = self::validateCardNumberForChoiceConstraintsFromSetCardNumber($cardNumber))) {
            throw new \InvalidArgumentException($cardNumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($cardNumber) && mb_strlen($cardNumber) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($cardNumber)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($cardNumber) && mb_strlen($cardNumber) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($cardNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9x]+)
        if (!is_null($cardNumber) && !preg_match('/[0-9x]+/', $cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9x]+', var_export($cardNumber, true)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get VaultId value
     * @return string
     */
    public function getVaultId()
    {
        return isset($this->VaultId) ? $this->VaultId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVaultId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVaultId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVaultIdForChoiceConstraintsFromSetVaultId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardNumber',
            'CardExpiryDate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VaultId can\'t be set as the property %s is already set. Only one property must be set among these properties: VaultId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VaultId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $vaultId
     * @return \StructType\CardPaymentRequestType
     */
    public function setVaultId($vaultId = null)
    {
        // validation for constraint: string
        if (!is_null($vaultId) && !is_string($vaultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vaultId, true), gettype($vaultId)), __LINE__);
        }
        // validation for constraint: choice(CardNumber, CardExpiryDate, VaultId)
        if ('' !== ($vaultIdChoiceErrorMessage = self::validateVaultIdForChoiceConstraintsFromSetVaultId($vaultId))) {
            throw new \InvalidArgumentException($vaultIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($vaultId) || (is_array($vaultId) && empty($vaultId))) {
            unset($this->VaultId);
        } else {
            $this->VaultId = $vaultId;
        }
        return $this;
    }
    /**
     * Get CVV value
     * @return string
     */
    public function getCVV()
    {
        return $this->CVV;
    }
    /**
     * Set CVV value
     * @param string $cVV
     * @return \StructType\CardPaymentRequestType
     */
    public function setCVV($cVV = null)
    {
        // validation for constraint: string
        if (!is_null($cVV) && !is_string($cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVV, true), gettype($cVV)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($cVV) && mb_strlen($cVV) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($cVV)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($cVV) && mb_strlen($cVV) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($cVV)), __LINE__);
        }
        // validation for constraint: pattern([0-9]+)
        if (!is_null($cVV) && !preg_match('/[0-9]+/', $cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]+', var_export($cVV, true)), __LINE__);
        }
        $this->CVV = $cVV;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\CardPaymentRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get CardExpiryDate value
     * @return string|null
     */
    public function getCardExpiryDate()
    {
        return isset($this->CardExpiryDate) ? $this->CardExpiryDate : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardExpiryDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardExpiryDate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardExpiryDateForChoiceConstraintsFromSetCardExpiryDate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardNumber',
            'VaultId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardExpiryDate can\'t be set as the property %s is already set. Only one property must be set among these properties: CardExpiryDate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardExpiryDate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $cardExpiryDate
     * @return \StructType\CardPaymentRequestType
     */
    public function setCardExpiryDate($cardExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiryDate) && !is_string($cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiryDate, true), gettype($cardExpiryDate)), __LINE__);
        }
        // validation for constraint: choice(CardNumber, CardExpiryDate, VaultId)
        if ('' !== ($cardExpiryDateChoiceErrorMessage = self::validateCardExpiryDateForChoiceConstraintsFromSetCardExpiryDate($cardExpiryDate))) {
            throw new \InvalidArgumentException($cardExpiryDateChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(([0][0-9]|[1][0-2])20[0-9]{2})
        if (!is_null($cardExpiryDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0][0-9]|[1][0-2])20[0-9]{2}', var_export($cardExpiryDate, true)), __LINE__);
        }
        if (is_null($cardExpiryDate) || (is_array($cardExpiryDate) && empty($cardExpiryDate))) {
            unset($this->CardExpiryDate);
        } else {
            $this->CardExpiryDate = $cardExpiryDate;
        }
        return $this;
    }
    /**
     * Get CardIssueDate value
     * @return string|null
     */
    public function getCardIssueDate()
    {
        return $this->CardIssueDate;
    }
    /**
     * Set CardIssueDate value
     * @param string $cardIssueDate
     * @return \StructType\CardPaymentRequestType
     */
    public function setCardIssueDate($cardIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssueDate) && !is_string($cardIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssueDate, true), gettype($cardIssueDate)), __LINE__);
        }
        // validation for constraint: pattern(([0][0-9]|[1][0-2])20[0-9]{2})
        if (!is_null($cardIssueDate) && !preg_match('/([0][0-9]|[1][0-2])20[0-9]{2}/', $cardIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0][0-9]|[1][0-2])20[0-9]{2}', var_export($cardIssueDate, true)), __LINE__);
        }
        $this->CardIssueDate = $cardIssueDate;
        return $this;
    }
    /**
     * Get CardIssueNumber value
     * @return string|null
     */
    public function getCardIssueNumber()
    {
        return $this->CardIssueNumber;
    }
    /**
     * Set CardIssueNumber value
     * @param string $cardIssueNumber
     * @return \StructType\CardPaymentRequestType
     */
    public function setCardIssueNumber($cardIssueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssueNumber) && !is_string($cardIssueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssueNumber, true), gettype($cardIssueNumber)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($cardIssueNumber) && mb_strlen($cardIssueNumber) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($cardIssueNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cardIssueNumber) && mb_strlen($cardIssueNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cardIssueNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9]+)
        if (!is_null($cardIssueNumber) && !preg_match('/[0-9]+/', $cardIssueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]+', var_export($cardIssueNumber, true)), __LINE__);
        }
        $this->CardIssueNumber = $cardIssueNumber;
        return $this;
    }
    /**
     * Get Vault value
     * @return bool|null
     */
    public function getVault()
    {
        return $this->Vault;
    }
    /**
     * Set Vault value
     * @param bool $vault
     * @return \StructType\CardPaymentRequestType
     */
    public function setVault($vault = false)
    {
        // validation for constraint: boolean
        if (!is_null($vault) && !is_bool($vault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vault, true), gettype($vault)), __LINE__);
        }
        $this->Vault = $vault;
        return $this;
    }
    /**
     * Get BudgetPeriod value
     * @return string|null
     */
    public function getBudgetPeriod()
    {
        return $this->BudgetPeriod;
    }
    /**
     * Set BudgetPeriod value
     * @param string $budgetPeriod
     * @return \StructType\CardPaymentRequestType
     */
    public function setBudgetPeriod($budgetPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($budgetPeriod) && !is_string($budgetPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budgetPeriod, true), gettype($budgetPeriod)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($budgetPeriod) && mb_strlen($budgetPeriod) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($budgetPeriod)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($budgetPeriod) && mb_strlen($budgetPeriod) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($budgetPeriod)), __LINE__);
        }
        // validation for constraint: pattern([0-9]+)
        if (!is_null($budgetPeriod) && !preg_match('/[0-9]+/', $budgetPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]+', var_export($budgetPeriod, true)), __LINE__);
        }
        $this->BudgetPeriod = $budgetPeriod;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectRequestType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectRequestType $redirect
     * @return \StructType\CardPaymentRequestType
     */
    public function setRedirect(\StructType\RedirectRequestType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\CardPaymentRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get AcquirerInfo value
     * @return \StructType\AcquirerInfoType|null
     */
    public function getAcquirerInfo()
    {
        return $this->AcquirerInfo;
    }
    /**
     * Set AcquirerInfo value
     * @param \StructType\AcquirerInfoType $acquirerInfo
     * @return \StructType\CardPaymentRequestType
     */
    public function setAcquirerInfo(\StructType\AcquirerInfoType $acquirerInfo = null)
    {
        $this->AcquirerInfo = $acquirerInfo;
        return $this;
    }
    /**
     * Get ThreeDSecure value
     * @return \StructType\ThreeDSecureType|null
     */
    public function getThreeDSecure()
    {
        return $this->ThreeDSecure;
    }
    /**
     * Set ThreeDSecure value
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @return \StructType\CardPaymentRequestType
     */
    public function setThreeDSecure(\StructType\ThreeDSecureType $threeDSecure = null)
    {
        $this->ThreeDSecure = $threeDSecure;
        return $this;
    }
    /**
     * Get Risk value
     * @return \StructType\RiskType|null
     */
    public function getRisk()
    {
        return $this->Risk;
    }
    /**
     * Set Risk value
     * @param \StructType\RiskType $risk
     * @return \StructType\CardPaymentRequestType
     */
    public function setRisk(\StructType\RiskType $risk = null)
    {
        $this->Risk = $risk;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cardPaymentRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$cardPaymentRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($cardPaymentRequestTypeUserDefinedFieldsItem) ? get_class($cardPaymentRequestTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($cardPaymentRequestTypeUserDefinedFieldsItem), var_export($cardPaymentRequestTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\CardPaymentRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\CardPaymentRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\CardPaymentRequestType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDescriptor, true), gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
}
