<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokenPaymentRequestType StructType
 * @subpackage Structs
 */
class TokenPaymentRequestType extends AbstractStructBase
{
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Token;
    /**
     * The TokenDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TokenDetail;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The Vault
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Vault;
    /**
     * The Redirect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectRequestType
     */
    public $Redirect;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The Risk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RiskType
     */
    public $Risk;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * The BillingDescriptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * Constructor method for TokenPaymentRequestType
     * @uses TokenPaymentRequestType::setToken()
     * @uses TokenPaymentRequestType::setTokenDetail()
     * @uses TokenPaymentRequestType::setAccount()
     * @uses TokenPaymentRequestType::setCustomer()
     * @uses TokenPaymentRequestType::setVault()
     * @uses TokenPaymentRequestType::setRedirect()
     * @uses TokenPaymentRequestType::setOrder()
     * @uses TokenPaymentRequestType::setRisk()
     * @uses TokenPaymentRequestType::setUserDefinedFields()
     * @uses TokenPaymentRequestType::setBillingDescriptor()
     * @param string $token
     * @param string $tokenDetail
     * @param \StructType\PayGateAccountType $account
     * @param \StructType\PersonType $customer
     * @param bool $vault
     * @param \StructType\RedirectRequestType $redirect
     * @param \StructType\OrderType $order
     * @param \StructType\RiskType $risk
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @param string $billingDescriptor
     */
    public function __construct($token = null, $tokenDetail = null, \StructType\PayGateAccountType $account = null, \StructType\PersonType $customer = null, $vault = false, \StructType\RedirectRequestType $redirect = null, \StructType\OrderType $order = null, \StructType\RiskType $risk = null, array $userDefinedFields = array(), $billingDescriptor = null)
    {
        $this
            ->setToken($token)
            ->setTokenDetail($tokenDetail)
            ->setAccount($account)
            ->setCustomer($customer)
            ->setVault($vault)
            ->setRedirect($redirect)
            ->setOrder($order)
            ->setRisk($risk)
            ->setUserDefinedFields($userDefinedFields)
            ->setBillingDescriptor($billingDescriptor);
    }
    /**
     * Get Token value
     * @return string
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\TokenPaymentRequestType
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get TokenDetail value
     * @return string
     */
    public function getTokenDetail()
    {
        return $this->TokenDetail;
    }
    /**
     * Set TokenDetail value
     * @param string $tokenDetail
     * @return \StructType\TokenPaymentRequestType
     */
    public function setTokenDetail($tokenDetail = null)
    {
        // validation for constraint: string
        if (!is_null($tokenDetail) && !is_string($tokenDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenDetail, true), gettype($tokenDetail)), __LINE__);
        }
        $this->TokenDetail = $tokenDetail;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\TokenPaymentRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\TokenPaymentRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Vault value
     * @return bool|null
     */
    public function getVault()
    {
        return $this->Vault;
    }
    /**
     * Set Vault value
     * @param bool $vault
     * @return \StructType\TokenPaymentRequestType
     */
    public function setVault($vault = false)
    {
        // validation for constraint: boolean
        if (!is_null($vault) && !is_bool($vault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vault, true), gettype($vault)), __LINE__);
        }
        $this->Vault = $vault;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectRequestType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectRequestType $redirect
     * @return \StructType\TokenPaymentRequestType
     */
    public function setRedirect(\StructType\RedirectRequestType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\TokenPaymentRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Risk value
     * @return \StructType\RiskType|null
     */
    public function getRisk()
    {
        return $this->Risk;
    }
    /**
     * Set Risk value
     * @param \StructType\RiskType $risk
     * @return \StructType\TokenPaymentRequestType
     */
    public function setRisk(\StructType\RiskType $risk = null)
    {
        $this->Risk = $risk;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tokenPaymentRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$tokenPaymentRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($tokenPaymentRequestTypeUserDefinedFieldsItem) ? get_class($tokenPaymentRequestTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($tokenPaymentRequestTypeUserDefinedFieldsItem), var_export($tokenPaymentRequestTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\TokenPaymentRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\TokenPaymentRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\TokenPaymentRequestType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDescriptor, true), gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
}
