<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingDetailsType StructType
 * @subpackage Structs
 */
class BillingDetailsType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * Constructor method for BillingDetailsType
     * @uses BillingDetailsType::setCustomer()
     * @uses BillingDetailsType::setAddress()
     * @param \StructType\PersonType $customer
     * @param \StructType\AddressType $address
     */
    public function __construct(\StructType\PersonType $customer = null, \StructType\AddressType $address = null)
    {
        $this
            ->setCustomer($customer)
            ->setAddress($address);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\BillingDetailsType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\BillingDetailsType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
