<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for QueryTransactionType EnumType
 * @subpackage Enumerations
 */
class QueryTransactionType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Authorisation'
     * @return string 'Authorisation'
     */
    const VALUE_AUTHORISATION = 'Authorisation';
    /**
     * Constant for value 'Settlement'
     * @return string 'Settlement'
     */
    const VALUE_SETTLEMENT = 'Settlement';
    /**
     * Constant for value 'Refund'
     * @return string 'Refund'
     */
    const VALUE_REFUND = 'Refund';
    /**
     * Constant for value 'Payout'
     * @return string 'Payout'
     */
    const VALUE_PAYOUT = 'Payout';
    /**
     * Constant for value 'Purchase'
     * @return string 'Purchase'
     */
    const VALUE_PURCHASE = 'Purchase';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return allowed values
     * @uses self::VALUE_AUTHORISATION
     * @uses self::VALUE_SETTLEMENT
     * @uses self::VALUE_REFUND
     * @uses self::VALUE_PAYOUT
     * @uses self::VALUE_PURCHASE
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTHORISATION,
            self::VALUE_SETTLEMENT,
            self::VALUE_REFUND,
            self::VALUE_PAYOUT,
            self::VALUE_PURCHASE,
            self::VALUE_ALL,
        );
    }
}
