<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransactionType EnumType
 * @subpackage Enumerations
 */
class TransactionType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Authorisation'
     * @return string 'Authorisation'
     */
    const VALUE_AUTHORISATION = 'Authorisation';
    /**
     * Constant for value 'Settlement'
     * @return string 'Settlement'
     */
    const VALUE_SETTLEMENT = 'Settlement';
    /**
     * Constant for value 'Refund'
     * @return string 'Refund'
     */
    const VALUE_REFUND = 'Refund';
    /**
     * Constant for value 'Payout'
     * @return string 'Payout'
     */
    const VALUE_PAYOUT = 'Payout';
    /**
     * Constant for value 'Purchase'
     * @return string 'Purchase'
     */
    const VALUE_PURCHASE = 'Purchase';
    /**
     * Return allowed values
     * @uses self::VALUE_AUTHORISATION
     * @uses self::VALUE_SETTLEMENT
     * @uses self::VALUE_REFUND
     * @uses self::VALUE_PAYOUT
     * @uses self::VALUE_PURCHASE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTHORISATION,
            self::VALUE_SETTLEMENT,
            self::VALUE_REFUND,
            self::VALUE_PAYOUT,
            self::VALUE_PURCHASE,
        );
    }
}
