<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringType StructType
 * @subpackage Structs
 */
class RecurringType extends AbstractStructBase
{
    /**
     * The Recurrent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Recurrent;
    /**
     * The OriginalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginalReference;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FrequencyType
     */
    public $Frequency;
    /**
     * Constructor method for RecurringType
     * @uses RecurringType::setRecurrent()
     * @uses RecurringType::setOriginalReference()
     * @uses RecurringType::setFrequency()
     * @param bool $recurrent
     * @param string $originalReference
     * @param \StructType\FrequencyType $frequency
     */
    public function __construct($recurrent = null, $originalReference = null, \StructType\FrequencyType $frequency = null)
    {
        $this
            ->setRecurrent($recurrent)
            ->setOriginalReference($originalReference)
            ->setFrequency($frequency);
    }
    /**
     * Get Recurrent value
     * @return bool|null
     */
    public function getRecurrent()
    {
        return $this->Recurrent;
    }
    /**
     * Set Recurrent value
     * @param bool $recurrent
     * @return \StructType\RecurringType
     */
    public function setRecurrent($recurrent = null)
    {
        // validation for constraint: boolean
        if (!is_null($recurrent) && !is_bool($recurrent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recurrent, true), gettype($recurrent)), __LINE__);
        }
        $this->Recurrent = $recurrent;
        return $this;
    }
    /**
     * Get OriginalReference value
     * @return string|null
     */
    public function getOriginalReference()
    {
        return $this->OriginalReference;
    }
    /**
     * Set OriginalReference value
     * @param string $originalReference
     * @return \StructType\RecurringType
     */
    public function setOriginalReference($originalReference = null)
    {
        // validation for constraint: string
        if (!is_null($originalReference) && !is_string($originalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalReference, true), gettype($originalReference)), __LINE__);
        }
        $this->OriginalReference = $originalReference;
        return $this;
    }
    /**
     * Get Frequency value
     * @return \StructType\FrequencyType|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param \StructType\FrequencyType $frequency
     * @return \StructType\RecurringType
     */
    public function setFrequency(\StructType\FrequencyType $frequency = null)
    {
        $this->Frequency = $frequency;
        return $this;
    }
}
