<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemType StructType
 * @subpackage Structs
 */
class OrderItemType extends AbstractStructBase
{
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDescription;
    /**
     * The ProductCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCategory;
    /**
     * The ProductRisk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductRisk;
    /**
     * The OrderQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrderQuantity;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $UnitPrice;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for OrderItemType
     * @uses OrderItemType::setProductCode()
     * @uses OrderItemType::setProductDescription()
     * @uses OrderItemType::setProductCategory()
     * @uses OrderItemType::setProductRisk()
     * @uses OrderItemType::setOrderQuantity()
     * @uses OrderItemType::setUnitPrice()
     * @uses OrderItemType::setCurrency()
     * @param string $productCode
     * @param string $productDescription
     * @param string $productCategory
     * @param string $productRisk
     * @param int $orderQuantity
     * @param float $unitPrice
     * @param string $currency
     */
    public function __construct($productCode = null, $productDescription = null, $productCategory = null, $productRisk = null, $orderQuantity = null, $unitPrice = null, $currency = null)
    {
        $this
            ->setProductCode($productCode)
            ->setProductDescription($productDescription)
            ->setProductCategory($productCategory)
            ->setProductRisk($productRisk)
            ->setOrderQuantity($orderQuantity)
            ->setUnitPrice($unitPrice)
            ->setCurrency($currency);
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\OrderItemType
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ProductDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->ProductDescription;
    }
    /**
     * Set ProductDescription value
     * @param string $productDescription
     * @return \StructType\OrderItemType
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDescription, true), gettype($productDescription)), __LINE__);
        }
        $this->ProductDescription = $productDescription;
        return $this;
    }
    /**
     * Get ProductCategory value
     * @return string|null
     */
    public function getProductCategory()
    {
        return $this->ProductCategory;
    }
    /**
     * Set ProductCategory value
     * @param string $productCategory
     * @return \StructType\OrderItemType
     */
    public function setProductCategory($productCategory = null)
    {
        // validation for constraint: string
        if (!is_null($productCategory) && !is_string($productCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCategory, true), gettype($productCategory)), __LINE__);
        }
        $this->ProductCategory = $productCategory;
        return $this;
    }
    /**
     * Get ProductRisk value
     * @return string|null
     */
    public function getProductRisk()
    {
        return $this->ProductRisk;
    }
    /**
     * Set ProductRisk value
     * @param string $productRisk
     * @return \StructType\OrderItemType
     */
    public function setProductRisk($productRisk = null)
    {
        // validation for constraint: string
        if (!is_null($productRisk) && !is_string($productRisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productRisk, true), gettype($productRisk)), __LINE__);
        }
        $this->ProductRisk = $productRisk;
        return $this;
    }
    /**
     * Get OrderQuantity value
     * @return int|null
     */
    public function getOrderQuantity()
    {
        return $this->OrderQuantity;
    }
    /**
     * Set OrderQuantity value
     * @param int $orderQuantity
     * @return \StructType\OrderItemType
     */
    public function setOrderQuantity($orderQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($orderQuantity) && !(is_int($orderQuantity) || ctype_digit($orderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderQuantity, true), gettype($orderQuantity)), __LINE__);
        }
        $this->OrderQuantity = $orderQuantity;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \StructType\OrderItemType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\OrderItemType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
