<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleVaultRequest StructType
 * @subpackage Structs
 */
class SingleVaultRequest extends AbstractStructBase
{
    /**
     * The CardVaultRequest
     * Meta information extracted from the WSDL
     * - choice: CardVaultRequest | WalletVaultRequest | LookUpVaultRequest | DeleteVaultRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CardVaultRequestType
     */
    public $CardVaultRequest;
    /**
     * The WalletVaultRequest
     * Meta information extracted from the WSDL
     * - choice: CardVaultRequest | WalletVaultRequest | LookUpVaultRequest | DeleteVaultRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\WalletVaultRequestType
     */
    public $WalletVaultRequest;
    /**
     * The LookUpVaultRequest
     * Meta information extracted from the WSDL
     * - choice: CardVaultRequest | WalletVaultRequest | LookUpVaultRequest | DeleteVaultRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\LookUpVaultRequestType
     */
    public $LookUpVaultRequest;
    /**
     * The DeleteVaultRequest
     * Meta information extracted from the WSDL
     * - choice: CardVaultRequest | WalletVaultRequest | LookUpVaultRequest | DeleteVaultRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\DeleteVaultRequestType
     */
    public $DeleteVaultRequest;
    /**
     * Constructor method for SingleVaultRequest
     * @uses SingleVaultRequest::setCardVaultRequest()
     * @uses SingleVaultRequest::setWalletVaultRequest()
     * @uses SingleVaultRequest::setLookUpVaultRequest()
     * @uses SingleVaultRequest::setDeleteVaultRequest()
     * @param \StructType\CardVaultRequestType $cardVaultRequest
     * @param \StructType\WalletVaultRequestType $walletVaultRequest
     * @param \StructType\LookUpVaultRequestType $lookUpVaultRequest
     * @param \StructType\DeleteVaultRequestType $deleteVaultRequest
     */
    public function __construct(\StructType\CardVaultRequestType $cardVaultRequest = null, \StructType\WalletVaultRequestType $walletVaultRequest = null, \StructType\LookUpVaultRequestType $lookUpVaultRequest = null, \StructType\DeleteVaultRequestType $deleteVaultRequest = null)
    {
        $this
            ->setCardVaultRequest($cardVaultRequest)
            ->setWalletVaultRequest($walletVaultRequest)
            ->setLookUpVaultRequest($lookUpVaultRequest)
            ->setDeleteVaultRequest($deleteVaultRequest);
    }
    /**
     * Get CardVaultRequest value
     * @return \StructType\CardVaultRequestType|null
     */
    public function getCardVaultRequest()
    {
        return isset($this->CardVaultRequest) ? $this->CardVaultRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardVaultRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardVaultRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardVaultRequestForChoiceConstraintsFromSetCardVaultRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WalletVaultRequest',
            'LookUpVaultRequest',
            'DeleteVaultRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardVaultRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: CardVaultRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardVaultRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CardVaultRequestType $cardVaultRequest
     * @return \StructType\SingleVaultRequest
     */
    public function setCardVaultRequest(\StructType\CardVaultRequestType $cardVaultRequest = null)
    {
        // validation for constraint: choice(CardVaultRequest, WalletVaultRequest, LookUpVaultRequest, DeleteVaultRequest)
        if ('' !== ($cardVaultRequestChoiceErrorMessage = self::validateCardVaultRequestForChoiceConstraintsFromSetCardVaultRequest($cardVaultRequest))) {
            throw new \InvalidArgumentException($cardVaultRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardVaultRequest) || (is_array($cardVaultRequest) && empty($cardVaultRequest))) {
            unset($this->CardVaultRequest);
        } else {
            $this->CardVaultRequest = $cardVaultRequest;
        }
        return $this;
    }
    /**
     * Get WalletVaultRequest value
     * @return \StructType\WalletVaultRequestType|null
     */
    public function getWalletVaultRequest()
    {
        return isset($this->WalletVaultRequest) ? $this->WalletVaultRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWalletVaultRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWalletVaultRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWalletVaultRequestForChoiceConstraintsFromSetWalletVaultRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardVaultRequest',
            'LookUpVaultRequest',
            'DeleteVaultRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property WalletVaultRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: WalletVaultRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set WalletVaultRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WalletVaultRequestType $walletVaultRequest
     * @return \StructType\SingleVaultRequest
     */
    public function setWalletVaultRequest(\StructType\WalletVaultRequestType $walletVaultRequest = null)
    {
        // validation for constraint: choice(CardVaultRequest, WalletVaultRequest, LookUpVaultRequest, DeleteVaultRequest)
        if ('' !== ($walletVaultRequestChoiceErrorMessage = self::validateWalletVaultRequestForChoiceConstraintsFromSetWalletVaultRequest($walletVaultRequest))) {
            throw new \InvalidArgumentException($walletVaultRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($walletVaultRequest) || (is_array($walletVaultRequest) && empty($walletVaultRequest))) {
            unset($this->WalletVaultRequest);
        } else {
            $this->WalletVaultRequest = $walletVaultRequest;
        }
        return $this;
    }
    /**
     * Get LookUpVaultRequest value
     * @return \StructType\LookUpVaultRequestType|null
     */
    public function getLookUpVaultRequest()
    {
        return isset($this->LookUpVaultRequest) ? $this->LookUpVaultRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLookUpVaultRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLookUpVaultRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLookUpVaultRequestForChoiceConstraintsFromSetLookUpVaultRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardVaultRequest',
            'WalletVaultRequest',
            'DeleteVaultRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LookUpVaultRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: LookUpVaultRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LookUpVaultRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LookUpVaultRequestType $lookUpVaultRequest
     * @return \StructType\SingleVaultRequest
     */
    public function setLookUpVaultRequest(\StructType\LookUpVaultRequestType $lookUpVaultRequest = null)
    {
        // validation for constraint: choice(CardVaultRequest, WalletVaultRequest, LookUpVaultRequest, DeleteVaultRequest)
        if ('' !== ($lookUpVaultRequestChoiceErrorMessage = self::validateLookUpVaultRequestForChoiceConstraintsFromSetLookUpVaultRequest($lookUpVaultRequest))) {
            throw new \InvalidArgumentException($lookUpVaultRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($lookUpVaultRequest) || (is_array($lookUpVaultRequest) && empty($lookUpVaultRequest))) {
            unset($this->LookUpVaultRequest);
        } else {
            $this->LookUpVaultRequest = $lookUpVaultRequest;
        }
        return $this;
    }
    /**
     * Get DeleteVaultRequest value
     * @return \StructType\DeleteVaultRequestType|null
     */
    public function getDeleteVaultRequest()
    {
        return isset($this->DeleteVaultRequest) ? $this->DeleteVaultRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDeleteVaultRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeleteVaultRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDeleteVaultRequestForChoiceConstraintsFromSetDeleteVaultRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardVaultRequest',
            'WalletVaultRequest',
            'LookUpVaultRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DeleteVaultRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: DeleteVaultRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DeleteVaultRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteVaultRequestType $deleteVaultRequest
     * @return \StructType\SingleVaultRequest
     */
    public function setDeleteVaultRequest(\StructType\DeleteVaultRequestType $deleteVaultRequest = null)
    {
        // validation for constraint: choice(CardVaultRequest, WalletVaultRequest, LookUpVaultRequest, DeleteVaultRequest)
        if ('' !== ($deleteVaultRequestChoiceErrorMessage = self::validateDeleteVaultRequestForChoiceConstraintsFromSetDeleteVaultRequest($deleteVaultRequest))) {
            throw new \InvalidArgumentException($deleteVaultRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($deleteVaultRequest) || (is_array($deleteVaultRequest) && empty($deleteVaultRequest))) {
            unset($this->DeleteVaultRequest);
        } else {
            $this->DeleteVaultRequest = $deleteVaultRequest;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SingleVaultRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
