<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SinglePayoutRequest StructType
 * @subpackage Structs
 */
class SinglePayoutRequest extends AbstractStructBase
{
    /**
     * The CardPayoutRequest
     * Meta information extracted from the WSDL
     * - choice: CardPayoutRequest | BankPayoutRequest | WalletPayoutRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CardPayoutRequestType
     */
    public $CardPayoutRequest;
    /**
     * The BankPayoutRequest
     * Meta information extracted from the WSDL
     * - choice: CardPayoutRequest | BankPayoutRequest | WalletPayoutRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\BankPayoutRequestType
     */
    public $BankPayoutRequest;
    /**
     * The WalletPayoutRequest
     * Meta information extracted from the WSDL
     * - choice: CardPayoutRequest | BankPayoutRequest | WalletPayoutRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\WalletPayoutRequestType
     */
    public $WalletPayoutRequest;
    /**
     * Constructor method for SinglePayoutRequest
     * @uses SinglePayoutRequest::setCardPayoutRequest()
     * @uses SinglePayoutRequest::setBankPayoutRequest()
     * @uses SinglePayoutRequest::setWalletPayoutRequest()
     * @param \StructType\CardPayoutRequestType $cardPayoutRequest
     * @param \StructType\BankPayoutRequestType $bankPayoutRequest
     * @param \StructType\WalletPayoutRequestType $walletPayoutRequest
     */
    public function __construct(\StructType\CardPayoutRequestType $cardPayoutRequest = null, \StructType\BankPayoutRequestType $bankPayoutRequest = null, \StructType\WalletPayoutRequestType $walletPayoutRequest = null)
    {
        $this
            ->setCardPayoutRequest($cardPayoutRequest)
            ->setBankPayoutRequest($bankPayoutRequest)
            ->setWalletPayoutRequest($walletPayoutRequest);
    }
    /**
     * Get CardPayoutRequest value
     * @return \StructType\CardPayoutRequestType|null
     */
    public function getCardPayoutRequest()
    {
        return isset($this->CardPayoutRequest) ? $this->CardPayoutRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardPayoutRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardPayoutRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardPayoutRequestForChoiceConstraintsFromSetCardPayoutRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BankPayoutRequest',
            'WalletPayoutRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardPayoutRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: CardPayoutRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardPayoutRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CardPayoutRequestType $cardPayoutRequest
     * @return \StructType\SinglePayoutRequest
     */
    public function setCardPayoutRequest(\StructType\CardPayoutRequestType $cardPayoutRequest = null)
    {
        // validation for constraint: choice(CardPayoutRequest, BankPayoutRequest, WalletPayoutRequest)
        if ('' !== ($cardPayoutRequestChoiceErrorMessage = self::validateCardPayoutRequestForChoiceConstraintsFromSetCardPayoutRequest($cardPayoutRequest))) {
            throw new \InvalidArgumentException($cardPayoutRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardPayoutRequest) || (is_array($cardPayoutRequest) && empty($cardPayoutRequest))) {
            unset($this->CardPayoutRequest);
        } else {
            $this->CardPayoutRequest = $cardPayoutRequest;
        }
        return $this;
    }
    /**
     * Get BankPayoutRequest value
     * @return \StructType\BankPayoutRequestType|null
     */
    public function getBankPayoutRequest()
    {
        return isset($this->BankPayoutRequest) ? $this->BankPayoutRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankPayoutRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankPayoutRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankPayoutRequestForChoiceConstraintsFromSetBankPayoutRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPayoutRequest',
            'WalletPayoutRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankPayoutRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: BankPayoutRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankPayoutRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankPayoutRequestType $bankPayoutRequest
     * @return \StructType\SinglePayoutRequest
     */
    public function setBankPayoutRequest(\StructType\BankPayoutRequestType $bankPayoutRequest = null)
    {
        // validation for constraint: choice(CardPayoutRequest, BankPayoutRequest, WalletPayoutRequest)
        if ('' !== ($bankPayoutRequestChoiceErrorMessage = self::validateBankPayoutRequestForChoiceConstraintsFromSetBankPayoutRequest($bankPayoutRequest))) {
            throw new \InvalidArgumentException($bankPayoutRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankPayoutRequest) || (is_array($bankPayoutRequest) && empty($bankPayoutRequest))) {
            unset($this->BankPayoutRequest);
        } else {
            $this->BankPayoutRequest = $bankPayoutRequest;
        }
        return $this;
    }
    /**
     * Get WalletPayoutRequest value
     * @return \StructType\WalletPayoutRequestType|null
     */
    public function getWalletPayoutRequest()
    {
        return isset($this->WalletPayoutRequest) ? $this->WalletPayoutRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWalletPayoutRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWalletPayoutRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWalletPayoutRequestForChoiceConstraintsFromSetWalletPayoutRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPayoutRequest',
            'BankPayoutRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property WalletPayoutRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: WalletPayoutRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set WalletPayoutRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WalletPayoutRequestType $walletPayoutRequest
     * @return \StructType\SinglePayoutRequest
     */
    public function setWalletPayoutRequest(\StructType\WalletPayoutRequestType $walletPayoutRequest = null)
    {
        // validation for constraint: choice(CardPayoutRequest, BankPayoutRequest, WalletPayoutRequest)
        if ('' !== ($walletPayoutRequestChoiceErrorMessage = self::validateWalletPayoutRequestForChoiceConstraintsFromSetWalletPayoutRequest($walletPayoutRequest))) {
            throw new \InvalidArgumentException($walletPayoutRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($walletPayoutRequest) || (is_array($walletPayoutRequest) && empty($walletPayoutRequest))) {
            unset($this->WalletPayoutRequest);
        } else {
            $this->WalletPayoutRequest = $walletPayoutRequest;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SinglePayoutRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
