<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleFollowUpRequest StructType
 * @subpackage Structs
 */
class SingleFollowUpRequest extends AbstractStructBase
{
    /**
     * The QueryRequest
     * Meta information extracted from the WSDL
     * - choice: QueryRequest | SettlementRequest | RefundRequest | VoidRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\QueryRequestType
     */
    public $QueryRequest;
    /**
     * The SettlementRequest
     * Meta information extracted from the WSDL
     * - choice: QueryRequest | SettlementRequest | RefundRequest | VoidRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SettleRequestType
     */
    public $SettlementRequest;
    /**
     * The RefundRequest
     * Meta information extracted from the WSDL
     * - choice: QueryRequest | SettlementRequest | RefundRequest | VoidRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RefundRequestType
     */
    public $RefundRequest;
    /**
     * The VoidRequest
     * Meta information extracted from the WSDL
     * - choice: QueryRequest | SettlementRequest | RefundRequest | VoidRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\VoidRequestType
     */
    public $VoidRequest;
    /**
     * Constructor method for SingleFollowUpRequest
     * @uses SingleFollowUpRequest::setQueryRequest()
     * @uses SingleFollowUpRequest::setSettlementRequest()
     * @uses SingleFollowUpRequest::setRefundRequest()
     * @uses SingleFollowUpRequest::setVoidRequest()
     * @param \StructType\QueryRequestType $queryRequest
     * @param \StructType\SettleRequestType $settlementRequest
     * @param \StructType\RefundRequestType $refundRequest
     * @param \StructType\VoidRequestType $voidRequest
     */
    public function __construct(\StructType\QueryRequestType $queryRequest = null, \StructType\SettleRequestType $settlementRequest = null, \StructType\RefundRequestType $refundRequest = null, \StructType\VoidRequestType $voidRequest = null)
    {
        $this
            ->setQueryRequest($queryRequest)
            ->setSettlementRequest($settlementRequest)
            ->setRefundRequest($refundRequest)
            ->setVoidRequest($voidRequest);
    }
    /**
     * Get QueryRequest value
     * @return \StructType\QueryRequestType|null
     */
    public function getQueryRequest()
    {
        return isset($this->QueryRequest) ? $this->QueryRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setQueryRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueryRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateQueryRequestForChoiceConstraintsFromSetQueryRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SettlementRequest',
            'RefundRequest',
            'VoidRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property QueryRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: QueryRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set QueryRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\QueryRequestType $queryRequest
     * @return \StructType\SingleFollowUpRequest
     */
    public function setQueryRequest(\StructType\QueryRequestType $queryRequest = null)
    {
        // validation for constraint: choice(QueryRequest, SettlementRequest, RefundRequest, VoidRequest)
        if ('' !== ($queryRequestChoiceErrorMessage = self::validateQueryRequestForChoiceConstraintsFromSetQueryRequest($queryRequest))) {
            throw new \InvalidArgumentException($queryRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($queryRequest) || (is_array($queryRequest) && empty($queryRequest))) {
            unset($this->QueryRequest);
        } else {
            $this->QueryRequest = $queryRequest;
        }
        return $this;
    }
    /**
     * Get SettlementRequest value
     * @return \StructType\SettleRequestType|null
     */
    public function getSettlementRequest()
    {
        return isset($this->SettlementRequest) ? $this->SettlementRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSettlementRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlementRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSettlementRequestForChoiceConstraintsFromSetSettlementRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'QueryRequest',
            'RefundRequest',
            'VoidRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SettlementRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: SettlementRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SettlementRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SettleRequestType $settlementRequest
     * @return \StructType\SingleFollowUpRequest
     */
    public function setSettlementRequest(\StructType\SettleRequestType $settlementRequest = null)
    {
        // validation for constraint: choice(QueryRequest, SettlementRequest, RefundRequest, VoidRequest)
        if ('' !== ($settlementRequestChoiceErrorMessage = self::validateSettlementRequestForChoiceConstraintsFromSetSettlementRequest($settlementRequest))) {
            throw new \InvalidArgumentException($settlementRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($settlementRequest) || (is_array($settlementRequest) && empty($settlementRequest))) {
            unset($this->SettlementRequest);
        } else {
            $this->SettlementRequest = $settlementRequest;
        }
        return $this;
    }
    /**
     * Get RefundRequest value
     * @return \StructType\RefundRequestType|null
     */
    public function getRefundRequest()
    {
        return isset($this->RefundRequest) ? $this->RefundRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRefundRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefundRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRefundRequestForChoiceConstraintsFromSetRefundRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'QueryRequest',
            'SettlementRequest',
            'VoidRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RefundRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: RefundRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RefundRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RefundRequestType $refundRequest
     * @return \StructType\SingleFollowUpRequest
     */
    public function setRefundRequest(\StructType\RefundRequestType $refundRequest = null)
    {
        // validation for constraint: choice(QueryRequest, SettlementRequest, RefundRequest, VoidRequest)
        if ('' !== ($refundRequestChoiceErrorMessage = self::validateRefundRequestForChoiceConstraintsFromSetRefundRequest($refundRequest))) {
            throw new \InvalidArgumentException($refundRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($refundRequest) || (is_array($refundRequest) && empty($refundRequest))) {
            unset($this->RefundRequest);
        } else {
            $this->RefundRequest = $refundRequest;
        }
        return $this;
    }
    /**
     * Get VoidRequest value
     * @return \StructType\VoidRequestType|null
     */
    public function getVoidRequest()
    {
        return isset($this->VoidRequest) ? $this->VoidRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVoidRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoidRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVoidRequestForChoiceConstraintsFromSetVoidRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'QueryRequest',
            'SettlementRequest',
            'RefundRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VoidRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: VoidRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VoidRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VoidRequestType $voidRequest
     * @return \StructType\SingleFollowUpRequest
     */
    public function setVoidRequest(\StructType\VoidRequestType $voidRequest = null)
    {
        // validation for constraint: choice(QueryRequest, SettlementRequest, RefundRequest, VoidRequest)
        if ('' !== ($voidRequestChoiceErrorMessage = self::validateVoidRequestForChoiceConstraintsFromSetVoidRequest($voidRequest))) {
            throw new \InvalidArgumentException($voidRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($voidRequest) || (is_array($voidRequest) && empty($voidRequest))) {
            unset($this->VoidRequest);
        } else {
            $this->VoidRequest = $voidRequest;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SingleFollowUpRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
