<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingDetailsType StructType
 * @subpackage Structs
 */
class ShippingDetailsType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryMethod;
    /**
     * The InstallationRequested
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $InstallationRequested;
    /**
     * Constructor method for ShippingDetailsType
     * @uses ShippingDetailsType::setCustomer()
     * @uses ShippingDetailsType::setAddress()
     * @uses ShippingDetailsType::setDeliveryDate()
     * @uses ShippingDetailsType::setDeliveryMethod()
     * @uses ShippingDetailsType::setInstallationRequested()
     * @param \StructType\PersonType $customer
     * @param \StructType\AddressType $address
     * @param string $deliveryDate
     * @param string $deliveryMethod
     * @param bool $installationRequested
     */
    public function __construct(\StructType\PersonType $customer = null, \StructType\AddressType $address = null, $deliveryDate = null, $deliveryMethod = null, $installationRequested = null)
    {
        $this
            ->setCustomer($customer)
            ->setAddress($address)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryMethod($deliveryMethod)
            ->setInstallationRequested($installationRequested);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\ShippingDetailsType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\ShippingDetailsType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\ShippingDetailsType
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DeliveryMethod value
     * @return string|null
     */
    public function getDeliveryMethod()
    {
        return $this->DeliveryMethod;
    }
    /**
     * Set DeliveryMethod value
     * @param string $deliveryMethod
     * @return \StructType\ShippingDetailsType
     */
    public function setDeliveryMethod($deliveryMethod = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMethod) && !is_string($deliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryMethod, true), gettype($deliveryMethod)), __LINE__);
        }
        $this->DeliveryMethod = $deliveryMethod;
        return $this;
    }
    /**
     * Get InstallationRequested value
     * @return bool|null
     */
    public function getInstallationRequested()
    {
        return $this->InstallationRequested;
    }
    /**
     * Set InstallationRequested value
     * @param bool $installationRequested
     * @return \StructType\ShippingDetailsType
     */
    public function setInstallationRequested($installationRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($installationRequested) && !is_bool($installationRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($installationRequested, true), gettype($installationRequested)), __LINE__);
        }
        $this->InstallationRequested = $installationRequested;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
