<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RiskType StructType
 * @subpackage Structs
 */
class RiskType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionId;
    /**
     * The IpV4Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IpV4Address;
    /**
     * The IpV6Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IpV6Address;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The MachineId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MachineId;
    /**
     * The UserProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $UserProfile;
    /**
     * The ConsumerWatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ConsumerWatch;
    /**
     * The Browser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BrowserType
     */
    public $Browser;
    /**
     * Constructor method for RiskType
     * @uses RiskType::setAccountNumber()
     * @uses RiskType::setSessionId()
     * @uses RiskType::setIpV4Address()
     * @uses RiskType::setIpV6Address()
     * @uses RiskType::setUserId()
     * @uses RiskType::setMachineId()
     * @uses RiskType::setUserProfile()
     * @uses RiskType::setConsumerWatch()
     * @uses RiskType::setBrowser()
     * @param string $accountNumber
     * @param string $sessionId
     * @param string $ipV4Address
     * @param string $ipV6Address
     * @param string $userId
     * @param string $machineId
     * @param string[] $userProfile
     * @param bool $consumerWatch
     * @param \StructType\BrowserType $browser
     */
    public function __construct($accountNumber = null, $sessionId = null, $ipV4Address = null, $ipV6Address = null, $userId = null, $machineId = null, array $userProfile = array(), $consumerWatch = null, \StructType\BrowserType $browser = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setSessionId($sessionId)
            ->setIpV4Address($ipV4Address)
            ->setIpV6Address($ipV6Address)
            ->setUserId($userId)
            ->setMachineId($machineId)
            ->setUserProfile($userProfile)
            ->setConsumerWatch($consumerWatch)
            ->setBrowser($browser);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\RiskType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \StructType\RiskType
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get IpV4Address value
     * @return string|null
     */
    public function getIpV4Address()
    {
        return $this->IpV4Address;
    }
    /**
     * Set IpV4Address value
     * @param string $ipV4Address
     * @return \StructType\RiskType
     */
    public function setIpV4Address($ipV4Address = null)
    {
        // validation for constraint: string
        if (!is_null($ipV4Address) && !is_string($ipV4Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipV4Address, true), gettype($ipV4Address)), __LINE__);
        }
        $this->IpV4Address = $ipV4Address;
        return $this;
    }
    /**
     * Get IpV6Address value
     * @return string|null
     */
    public function getIpV6Address()
    {
        return $this->IpV6Address;
    }
    /**
     * Set IpV6Address value
     * @param string $ipV6Address
     * @return \StructType\RiskType
     */
    public function setIpV6Address($ipV6Address = null)
    {
        // validation for constraint: string
        if (!is_null($ipV6Address) && !is_string($ipV6Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipV6Address, true), gettype($ipV6Address)), __LINE__);
        }
        $this->IpV6Address = $ipV6Address;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\RiskType
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get MachineId value
     * @return string|null
     */
    public function getMachineId()
    {
        return $this->MachineId;
    }
    /**
     * Set MachineId value
     * @param string $machineId
     * @return \StructType\RiskType
     */
    public function setMachineId($machineId = null)
    {
        // validation for constraint: string
        if (!is_null($machineId) && !is_string($machineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($machineId, true), gettype($machineId)), __LINE__);
        }
        $this->MachineId = $machineId;
        return $this;
    }
    /**
     * Get UserProfile value
     * @return string[]|null
     */
    public function getUserProfile()
    {
        return $this->UserProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setUserProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserProfileForArrayConstraintsFromSetUserProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $riskTypeUserProfileItem) {
            // validation for constraint: itemType
            if (!is_string($riskTypeUserProfileItem)) {
                $invalidValues[] = is_object($riskTypeUserProfileItem) ? get_class($riskTypeUserProfileItem) : sprintf('%s(%s)', gettype($riskTypeUserProfileItem), var_export($riskTypeUserProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserProfile property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserProfile value
     * @throws \InvalidArgumentException
     * @param string[] $userProfile
     * @return \StructType\RiskType
     */
    public function setUserProfile(array $userProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($userProfileArrayErrorMessage = self::validateUserProfileForArrayConstraintsFromSetUserProfile($userProfile))) {
            throw new \InvalidArgumentException($userProfileArrayErrorMessage, __LINE__);
        }
        $this->UserProfile = $userProfile;
        return $this;
    }
    /**
     * Add item to UserProfile value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RiskType
     */
    public function addToUserProfile($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The UserProfile property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserProfile[] = $item;
        return $this;
    }
    /**
     * Get ConsumerWatch value
     * @return bool|null
     */
    public function getConsumerWatch()
    {
        return $this->ConsumerWatch;
    }
    /**
     * Set ConsumerWatch value
     * @param bool $consumerWatch
     * @return \StructType\RiskType
     */
    public function setConsumerWatch($consumerWatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($consumerWatch) && !is_bool($consumerWatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($consumerWatch, true), gettype($consumerWatch)), __LINE__);
        }
        $this->ConsumerWatch = $consumerWatch;
        return $this;
    }
    /**
     * Get Browser value
     * @return \StructType\BrowserType|null
     */
    public function getBrowser()
    {
        return $this->Browser;
    }
    /**
     * Set Browser value
     * @param \StructType\BrowserType $browser
     * @return \StructType\RiskType
     */
    public function setBrowser(\StructType\BrowserType $browser = null)
    {
        $this->Browser = $browser;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RiskType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
